SET SCAN OFF

PROMPT
PROMPT #########################################################################
PROMPT ##                                                                     ##
PROMPT ##       _/_/_/_/              _/_/_/      _/_/      _/_/_/    _/_/_/  ##
PROMPT ##      _/        _/      _/  _/    _/  _/    _/  _/        _/         ##
PROMPT ##     _/_/_/    _/      _/  _/_/_/    _/    _/  _/          _/_/      ##
PROMPT ##    _/          _/  _/    _/    _/  _/    _/  _/              _/     ##
PROMPT ##   _/_/_/_/      _/      _/    _/    _/_/      _/_/_/  _/_/_/        ##
PROMPT ##                                                                     ##
PROMPT #########################################################################
PROMPT

DECLARE
  e_no_table   EXCEPTION;
  PRAGMA EXCEPTION_INIT (e_no_table,-942);  -- ORA-00942: table or view does not exist
BEGIN
  EXECUTE IMMEDIATE 'DROP TABLE ero_kscope_sessions';
  dbms_output.put_line ('Existing table was dropped');
EXCEPTION
  WHEN e_no_table
  THEN
    dbms_output.put_line ('Table ero_kscope_sessions is new for this schema!');
END;
/

CREATE TABLE ero_kscope_sessions
(topic        VARCHAR2(50)
,subtopic     VARCHAR2(50)
,starttime    DATE
,endtime      DATE
,session_id   VARCHAR2(30)
,presenter    VARCHAR2(50)
,company      VARCHAR2(100)
,copresenter  VARCHAR2(100)
,title        VARCHAR2(150)
,description  VARCHAR2(4000)
);



INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','OBIEE',NULL,NULL,NULL,'Patrick Abram','Perficient',NULL,'Accelerating Oracle BI Apps with Essbase 12c',REPLACE('In this case study, see how the Essbase 12c features of Oracle BI Foundation Suite improve the performance of the Oracle Business Analytics Warehouse. Oracle BI Applications are designed to drill from highly aggregated reports down to the detailed records. Learn how to identify and prioritize the analytical use cases that will benefit from query acceleration. Specific attention will be paid to Financial, Human Resources, Time & Expense, and Project Analytics.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','OBIEE',NULL,NULL,NULL,'Gary Adashek','General Electric',NULL,'Data Train: ALL ABOARD! Essbase Drill, OBI, and Big Data',REPLACE('Oracle Business Intelligence (OBI) is a powerful toolkit for users to drive analysis, reporting, dashboards, and more. But what if there is not a native adapter for the data set you are interested in exploring, federating, and stitching together in OBI? And what if you also wanted to enable Essbase Studio Drill-Through reports to this Big Data? In this presentation, I will provide a solution that includes, Big Data (Pivotal Greenplum), OBI, and Essbase Studio Drill-Through reporting.<<CHR(10)>><<CHR(10)>>This presentation will take a detailed look into the architecture and development that enabled the successful execution of this solution. It will give a step-by-step walk-through of Essbase Studio Drill-Through reports, both Relational and URL types as well as the setup of OBI Subject Areas used to enable the federation of data to a non-Oracle Big Data source.<<CHR(10)>><<CHR(10)>>The benefits that users have received from this work are:<<CHR(10)>>&bull;  OBI Subject Areas<<CHR(10)>>&bull;  Essbase Studio: Drill-Through report types<<CHR(10)>>&bull;  The financial data visibility from General Ledger to Journals to Sub-Ledgers<<CHR(10)>>&bull;  Data drill-ability plus data threading via OBIEE integrated with Greenplum Big Data','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','Other Database',NULL,NULL,NULL,'Liron Amitzi','DBAces',NULL,'Look Inside the Locking Mechanism',REPLACE('Locking issues have always been an interesting topic. This is one of the most important features that maintain the integrity of our database. <<CHR(10)>><<CHR(10)>>Why do we need the locking mechanism? What locking modes and types are there? What does Oracle lock during DML and DDL operations? How are constraints and indexes affected by and affecting locks? These are some of the questions this session handles. It also includes live demos for some advanced and interesting scenarios and shows how to query relevant data dictionary views.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Data Integration','Data management/integration',NULL,NULL,NULL,'Francisco Amores','Infratects',NULL,'Black Belt Techniques for FDMEE Admins and Developers',REPLACE('Willing to take your application to the next level? <<CHR(10)>><<CHR(10)>>FDMEE is a product that can be easily customized to meet any requirement, regardless of its complexity. You may know what you want to do but can''t find the right approach.<<CHR(10)>><<CHR(10)>>What about adding a creativeness layer on top of your FDMEE knowledge? The solution may be closer than you think, either using standard functionality or scripting. <<CHR(10)>><<CHR(10)>>In this session, we will cover some nice techniques, tips, and tricks that will give you a helping hand to get the most out of FDMEE.<<CHR(10)>><<CHR(10)>>Using locations for admin purposes, enhancing batch management with custom scripts, or using lookup dimensions and SQL map scripts to define standard multi-dim maps based on target dimensions are just some of the techniques we will talk about.<<CHR(10)>><<CHR(10)>>Don''t miss this session, regardless of your level, if you want to see how standard functionality can turn into simple and powerful solutions.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Administration',NULL,NULL,NULL,'Bernard Ash','EPM Clarity',NULL,'Exalytics-Compatible: Automate Your Linux Backups',REPLACE('Let''s automate and schedule the backup of our large Essbase Linux deployments   including Exalytics. Leveraging LCM is great, but we should really back up more such as file system backups, MAXL parallel data exports, and our Essbase partition definitions that cannot currently be backed up using MAXL or LCM.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Business Content','EPM/BI Strategies',NULL,NULL,NULL,'Joe Aultman','interRel Consulting',NULL,'Is Your EPM Implementation Falling Behind? The Top 11 Signs',REPLACE('In the EPM world, there is a constant need to keep moving forward to better and better practices. Applications and processes that used to be sufficient become outdated and stale. There are many reasons implementations at different companies may begin to lag, and environments that were once cutting-edge become antiquated. Come to this session to find out how to recognize when you are falling behind so you can take action. Find out how to make certain your EPM and BI practices are up to today''s standards so you can keep the competition at bay.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Planning','Cloud Technologies - PBCS & EPBCS focused',NULL,NULL,NULL,'Joe Aultman','interRel Consulting',NULL,'Don''t Worry, You Can Still Get Geeky with Planning Cloud',REPLACE('As with all of their cloud products, Oracle wants EPBCS to be friendly to users and administrators in the business community, reducing the level of technical expertise required to implement and maintain the application. Techies everywhere are left to wonder what role is left for them. This session provides the answer. From new techniques for creating custom functions to tweaking the user interface to automating processes and data flows, you''ll see there is still plenty for the geeky among us to do.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','New Release',NULL,NULL,NULL,'Dietmar Aust','Opal-Consulting',NULL,'APEX 5.1: The Smaller New Features You Can''t Afford to Ignore',REPLACE('With every new release of Oracle APEX, everybody talks about the major (so-called marquee) features such as Interactive Grids, Master/Detail/Detail, the new Charting Engine, and the enhancements to the Page Designer. <<CHR(10)>><<CHR(10)>>But aside from that, typically over 100 smaller enhancements have been added to the product that make our lives as APEX developers a lot easier and are really valuable to learn about; typically they are not talked about that much. <<CHR(10)>><<CHR(10)>>These features have been analyzed by talking with the APEX team and also by comparing the differences in the data model and APIs between version 5.1 and 5.0. <<CHR(10)>><<CHR(10)>>These smaller features include the new Proxy Authentication (with ORDS), the change in the architecture (moving to a JSON-based page rendering/submission that removes certain restrictions such as the number of items per page), javascript apis for notifications (apex.message), improvements in the modal dialogs, the javascript apis for the interactive grid, and many more.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Data Visualization & Advanced Analytics','Oracle Data Visualization',NULL,NULL,NULL,'Justin Baker','Oracle Corporation',NULL,'Integrating Raspberry Pi Sensors with Data Visualization',REPLACE('The introduction of IoT devices such as the Raspberry Pi and services such as IFTTT have disrupted whole industries overnight and spawned an army of machines gathering sensor data and home automation capabilities to better our lives for a fraction of the cost before. In this session, we will explore how integrating IoT device sensor data with Oracle Data Visualization and IFTTT can help us hold both Mother Nature and our ISPs accountable in this new disruptive landscape.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Tools',NULL,NULL,NULL,'Galo Balda','State of Texas',NULL,'SQLcl: A Modern Command Line Interface to the Oracle Database',REPLACE('SQLcl is a Java-based command line interface that takes advantage of SQL Developer s scripting engine to deliver a modern command line interface that is backward compatible with SQL*Plus but also introduces new commands and usability enhancements that have been missing for a long time. Come to this session to see a demo showing the new inline editor, query history, aliasing, result formatting, DDL generation, JavaScript support, and other exciting features that set SQLcl apart from its predecessor.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Financial Close','Financial Close Management (FCM, ARM, SDM)',NULL,NULL,NULL,'Catherine Baldasty','Global Business Intelligence','Laura Potts, Global Business Intelligence, LLC','Close Manager: Your Interactive Project Manager',REPLACE('Are you sick and tired of maintaining your close through post-it notes and individual checklists? Don t miss your delivery to senior management because you don t know about a bottleneck in your close process. Meet Close Manager, your interactive project manager. Watch as we eliminate those bottlenecks by creating schedules with email notifications where progress and completion can be managed from a central dashboard. Let us show you how to make FCM rival all other project tools combined.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Financial Close','Other Financial Close',NULL,NULL,NULL,'Christopher Barbieri','Finit Solutions',NULL,'Campfire Stories: Tips for Making Life Easier for the Financial Close Administrator',REPLACE('Life for the financial close administrator can be pretty rough at times. As they say,  necessity is the mother of invention," and so we invite you to gather around, pull up a seat and listen to true stories from folks like you as they share tips and inventions that make their lives easier. Stories cover a range of home-made utilities, macros, tips for using Notepad++, novel ideas with custom member lists, dashboards in Smart View, interesting uses for WriteToFile, and more. We hope the tips from this Deep Dive session will inspire you and make your life easier too!','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Financial Close','HFM',NULL,NULL,NULL,'Christopher Barbieri','Finit Solutions',NULL,'Backstage Pass: Lesser-Known Features for Easier HFM Management',REPLACE('Oracle ACE Chris Barbieri takes you backstage to work with some lesser-known HFM administrator features. We ll investigate the Insights module, review common System Messages, and make use of the Admin mode while performing application updates. We ll discuss a few of HFM s system settings to control HFM s behavior and explore the Module Configuration. Finally, we ll cover Shared Services logs and HFM s data audit log for tracking user activity and data changes. Please note that although some of these features are particular to 11.1.2.4, many of them apply to earlier versions.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Financial Close','HFM',NULL,NULL,NULL,'Christopher Barbieri','Finit Solutions',NULL,'What Would Happen If I Did ... in HFM? Greatest Hits and Disasters',REPLACE('Ever wonder what would happen if you changed the currency on an entity? Or switched an account to be IsCalculated? Or renamed an account? Have you made metadata changes and loaded the file without the check integrity flag? Oracle ACE Chris Barbieri revisits these and other HFM topics, taking a Mythbusters approach to defining the myths, setting up the tests, and explaining what happens "under the hood" so you can more deeply understand what would happen if I did ... in HFM.<<CHR(10)>><<CHR(10)>>This is a compilation of popular topics from three "What Would Happen..." presentations and is geared toward HFM administrators and power users, though all are welcome.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Essbase-related technologies',NULL,NULL,NULL,'Greg Beaton','TGG','Nikhil Virmani, ATOS','Hybrid Essbase in the Real World: A Production Example with Maintenance-Free Currency Conversion',REPLACE('What s Hybrid Essbase all about? What can it do, and what can t it do? What do I need to know to both implement and use it? Should I use it? Learn how we turned a poorly performing ASO cube into a speedy Hybrid cube, adding ease of use with access to the BSO calculator while retaining fast dynamic aggregations.<<CHR(10)>><<CHR(10)>>Learn the advantages and disadvantages of the new Hybrid Essbase Engine from a company that has been using it in production for almost a full year. Both the Essbase Architect and Client Administrator will be on hand to discuss how Hybrid Essbase performs in the real world.<<CHR(10)>><<CHR(10)>>We will discuss hybrid cube design and our evolution of getting there. Learn about our 16-dimension cube with maintenance-free custom currency conversions using the BSO Calculator that aggregates instantaneously. We will touch on the benefits and pitfalls of using Hybrid and discuss our lessons learned. If you are thinking of going Hybrid, this session will reveal some of the secrets you need to know.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Planning','Cloud Technologies - PBCS & EPBCS focused',NULL,NULL,NULL,'Philip Benz','Peloton Group','Paul Hurley, Cumberland Farms','Looking After the Pennies: Unlocking the Detail Behind the Data',REPLACE('Drill through capabilities unlock endless opportunities for analysis to the lowest grain of detail. Clients have been clamoring for this capability ever since its introduction into PBCS. Come see how Cumberland Farms is able to use drill through capabilities to perform more robust analysis than ever before.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','OBIEE',NULL,NULL,NULL,'Christian Berg','Dimensionality','Robin Moffatt, Rittman Mead','When Good Queries Go Bad: OBIEE Performance Deep Dive',REPLACE('Performance is a crucial part of any successful system. Obtaining good performance is not fiddling with configuration files to set GOFASTER=TRUE but about analyzing the behavior of a system to obtain data proving how it can be made more efficient.<<CHR(10)>><<CHR(10)>>In this presentation, we will look at how OBIEE runs a query and discuss the different areas of implementation in which mistakes are made and impact performance adversely. Based on a popular OTN paper (http://ritt.md/otn-obi-perf) and a widespread Worst Practices presentation (http://goo.gl/gTirfR), we will explore the metrics available in order to prove how a query is performing and crucially identify where to improve it if necessary as well as more advanced metrics such as those from DMS. We will also see how Usage Tracking alone can be a gold mine of data for investigating performance issues. Different use cases with different solution possibilities will be included, as one size does not fit all.<<CHR(10)>><<CHR(10)>>This presentation will be a fun-filled 45 minutes of practical examples of how YOU can analyze the real causes of performance problems on your OBIEE system and resolve them   it''s like GOFASTER=TRUE, only better.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Financial Close','HFM',NULL,NULL,NULL,'Keith Berry','The Hackett Group',NULL,'The HFM Value Dimension in Four Easy Concepts',REPLACE('If the standard explanations of the value dimension leave you confused, this session is for you.<<CHR(10)>><<CHR(10)>>The value dimension makes perfect sense once you understand the underlying operation of the HFM consolidation engine. We''ll break down that information into four basic concepts, each of which explains an (otherwise perplexing) aspect of the value dimension. We''ll skip the abstract diagrams and learn about these concepts with pictures of dogs, dice, and other everyday things. You''ll walk out of the presentation with a complete understanding of the value dimension and a deeper appreciation of how things really work in HFM.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Financial Close','HFM',NULL,NULL,NULL,'Keith Berry','The Hackett Group',NULL,'Understanding HFM System Tables',REPLACE('The HFM repository is not designed to be accessed directly, so there is little official documentation on how it works. This presentation will try to shed some light on the inner workings of the HFM database.<<CHR(10)>><<CHR(10)>>In the first part of the session, we''ll cover the basics of the HFM repository and the architecture of the primary table sets for storing data, journals, and metadata. In the second part of the session, we will go through a cookbook of useful queries for troubleshooting errors, extracting hierarchies, and analyzing audit data. <<CHR(10)>><<CHR(10)>>The presentation is for HFM administrators/developers and integration specialists who use HFM as their data source. Some knowledge of relational databases will be helpful, but the material will be useful to anyone looking for a greater understanding of how HFM works.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Planning','Design',NULL,NULL,NULL,'Thomas Blakeley','Performance Architects','Michael Bender, Vertex Pharmaceuticals','Diagnosis Close: How Vertex Pharma Uses Planning, Essbase, and OBIEE to Close the Books',REPLACE('Planning isn''t just for budgets anymore!  <<CHR(10)>><<CHR(10)>>Hear how Vertex Pharmaceuticals used Planning, ASO native Essbase Cubes, and OBIEE to assist with revenue accounting and the tracking of adjustments such as fee calculations and revenue recognition in a single place. Utilizing Hyperion Planning, ASO Essbase, and OBIEE, accounting users are able to review invoicing and sales data fed directly from third-party logistics companies located around the world before adjusting revenue dates, inputting fees, and making custom entries   all through Planning. After working through the Revenue Task List, users can initiate data warehouse jobs directly from Planning Task Lists that push data to a reporting application and OBIEE for review across additional dimensions and currencies. <<CHR(10)>><<CHR(10)>>This all follows a workflow built using Task Lists that guide users through the revenue accounting process. This entire process supports the final revenue numbers booked directly into EBS and also supports revenue analytics for the entire organization. <<CHR(10)>><<CHR(10)>>So, come to our session! <<CHR(10)>><<CHR(10)>>Hear about an end-to-end solution involving more that just one Oracle EPM and BI product   and hear about a solution that actually integrates them. <<CHR(10)>><<CHR(10)>>Hear about how OBIEE can report directly on data found within Planning and Essbase.<<CHR(10)>><<CHR(10)>>Hear about a Planning cube with seven dimensions getting transformed into an ASO Essbase application with 16 dimensions   and an OBIEE model with even more columns for reporting. <<CHR(10)>><<CHR(10)>>Hear how end users are able to get access to summary revenue numbers and then drill down to the detail if they feel the need. Hear the process by which we made it happen   from stakeholder meetings at the beginning through to our production rollout at the end. <<CHR(10)>><<CHR(10)>>Finally, don''t just hear it from the consultant but also hear from the customer, as we both share our tips and tricks and what went well.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Planning','Cloud Technologies - PBCS & EPBCS focused',NULL,NULL,NULL,'Nicholas Blazosky','TopDown Consulting','Ludovic De Paz, TopDown Consulting','Elevating Your Workforce Planning Solution to the Cloud',REPLACE('Thinking about elevating your organization s Workforce Planning Solution? Want to see a detailed demo of the capabilities of the latest version of Oracle Enterprise Planning and Budgeting Cloud Service (EPBCS) SWP (Strategic Workforce Planning) and Workforce planning modules? What has changed since the days of deployment in on-premise, and how can you be leveraging the enhanced functionality for your organization? Learn the differences between an on-premise deployment and strategies for getting you to the cloud in no time. The demo will have a unique San Antonio twist to get you in the spirit of being in the heart of South Texas. Join seasoned WFP architects and Kscope speakers Ludovic De Paz and San Antonio native Nicholas Blazosky for this informative deep dive into the newly enhanced world of Workforce.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Infrastructure','Cloud and Hybrid Infrastructure',NULL,NULL,NULL,'John Booth','METAVERO',NULL,'Shootout at the Public Cloud Corral: Oracle vs. Amazon vs. Google vs. Microsoft',REPLACE('How do these Infrastructure as a Service offerings stack up in terms of features,<<CHR(10)>>price, and performance? We will set up an all-in-one Hyperion environment including Planning and HFM on four major public cloud providers and discuss ease of use, management, and how a Hybrid cloud environment integrates with your on-premise systems.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Essbase-related technologies',NULL,NULL,NULL,'John Booth','METAVERO',NULL,'Essbase Dashboard Smackdown!',REPLACE('Confused about which solution to pursue for Essbase visualization? We compare Web Analysis vs. Tableau vs. Oracle BI vs. other contenders in performance, prettiness, and power. Which tools make sense to embrace?','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Other Essbase',NULL,NULL,NULL,'William Bradstreet','Bradstreet Business Services',NULL,'Programming (Flexible) Automation to Use Processing Cubes (and Other Automation Tricks)',REPLACE('Essbase must be automated, but most Essbase automation consists of a MaxL script within a .cmd/.sh file. But that s crude, inconsistent, and a maintenance nightmare. A better approach is a parameter-driven automation framework that dynamically spawns batch streams, applies the same processes consistently, and   because the actual code base is small   centralizes maintenance. As a bonus, this ease of development streamlines the migration from development to quality to production. Join Bill Bradstreet as he describes, demonstrates, and dives into a programming methodology and the code behind it to show how you can bring the power and flexibility of this approach to your system today.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Business Content','Other EPM Business Content',NULL,NULL,NULL,'Greg Briscoe','Razza Solutions',NULL,'Why IoT and Big Data Need Data Relationship Management',REPLACE('The Internet of Things (IoT) is expected to offer advanced connectivity of many different kinds of devices, systems, and services that go well beyond just machine-to-machine (M2M) communications. IoT covers a variety of communication protocols, industry domains, and business applications. The interconnection of these devices and other smart objects is expected to make an impact in automation and integration for almost all types of business. Both the private and public sector will benefit from the IoT, and we should see further enabling of more advanced decision-making applications.<<CHR(10)>><<CHR(10)>>In this session, we will learn how Oracle''s Data Relationship Management can help you transform and report on the large volume and velocity of data that is streaming through the IoT into the enterprise. This is big data, and we will help you understand how and why Data Relationship Management is a critical part of making data collected from IoT useful.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Other Application Express',NULL,NULL,NULL,'Paul Broughton','APEX Evangelists',NULL,'Have You Sampled the Packaged Apps?',REPLACE('APEX 5.1 has over 35 packaged applications, with many showing the very latest APEX enhancements. Many of these may be new to developers, and this presentation will discuss and demonstrate some these in use such as the Interactive Grid and Jet Charts. This presentation will dive into a number of packaged applications, looking for some of the most innovative and powerful features. It will demonstrate the basics such as simply installing and managing the packaged applications.<<CHR(10)>><<CHR(10)>>After demonstrating some of these unique features, the presentation will build real-life examples into custom APEX applications. <<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Data Warehousing & Big Data','Data Architecture',NULL,NULL,NULL,'Stewart Bryson','Red Pill Analytics',NULL,'Data Streaming and Analytic Microservices',REPLACE('While traditional data warehouses excel at sourcing data from enterprise applications, they usually fail at handling the volume, velocity, and variety of data for modern analytics applications relying on big and fast data. Instead of modeling these data sources into a system that doesn''t fit, let''s apply a new software design pattern to analytics: microservices. Microservices are small, independent applications   building blocks that provide only a distinct subset of functionality   that can be stacked together to build an end-to-end platform.<<CHR(10)>><<CHR(10)>>In this presentation, we''ll explore using Apache Kafka and the Confluent Platform 3.0 as the data streaming hub for ingesting data bound for downstream analytic applications: an enterprise data warehouse, a Hadoop cluster for batch processing, and lightweight, purpose-built microservices in the cloud or on-premises. Experience the next generation of analytic platforms.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Planning','Optimization',NULL,NULL,NULL,'Ryan Burghauser','SC&H Group','Nick Scott, SC&H Group','From Bogeys to Birdies: All You Need Is Drivers',REPLACE('When a Fortune 500 hospitality company wanted improved forecasting and budgeting accuracy, it turned to a customizable driver-based approach. The hard part was coming up with a model that suited a 2,400-person user base. We had to tap into the creativity bank to allow users the ability to update their calculation methods on demand and already have the related drivers populated in the application. The reliance upon drivers shifted users away from focusing on the end revenue and expense dollar figures and turned the attention toward how did we get there.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Data Integration','Metadata management/integration',NULL,NULL,NULL,'Kris Calabro','JCI','Natalie Delemar, Ernst & Young','A DRM Journey: A N00b''s Perspective',REPLACE('Not all that long ago, DRM was a mystery: No one really could agree on what the acronym DRM spelled out   was it Data Relationship Management or maybe Dimension Relational Manager or maybe something else   or understand how the tool worked or even appreciate DRM''s role in the EPM ecosystem. Today we know what DRM means (Data Relationship Management); have mastered (sort of) its features, functions, and intricacies; and can truly understand the value it brings in managing metadata across an Oracle EPM implementation''s many tools and applications. Join Tyco EPM administrators as they review the transformative role of DRM, the challenges faced and solutions derived, and why every new Tyco application has DRM at its core.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','New Release',NULL,NULL,NULL,'Karen Cannell','TH Technology',NULL,'Going to the Grid: What the APEX 5.1 Interactive Grid Means for You and Your End Users',REPLACE('The long-awaited APEX 5.1 Interactive Grid region is here   but what does it mean to you and your end users? Need some practical guidance on when, why, and how to adopt the Interactive Grid region type? This session is for those who have seen the introductory demonstrations, are looking to upgrade to APEX 5.1, and need some advice. Does the Interactive Grid replace Interactive Reports? No more Tabular Forms? This session answers practical functional and technical questions raised by this new region type: <<CHR(10)>><<CHR(10)>>&bull;  When and why should I upgrade existing regions to Interactive Grid?<<CHR(10)>>&bull;  Is there an upgrade wizard?<<CHR(10)>>&bull;  What features will I gain; what features will I lose?<<CHR(10)>>&bull;  What about customizations   will they upgrade?<<CHR(10)>>&bull;  How does an editable Interactive Grid compare to my existing tabular form?<<CHR(10)>>&bull;  Which features must still be manually written? Do I still need to write all that collection logic?<<CHR(10)>>&bull;  How can I customize appearance?<<CHR(10)>>&bull;  How can I add dynamic actions?<<CHR(10)>>&bull;  Can I extend the Interactive Grid functionality?<<CHR(10)>>&bull;  Will my end users like it? What about data entry users?<<CHR(10)>>This session compares and contrasts Interactive Grids with the Interactive Reports and tabular forms we are familiar with. We will pay particular attention to maintaining or replacing features and common customizations in existing applications: checkboxes, 32K limits, cascading select lists, row-level validations, interactions between columns, and navigation between fields. How does the Interactive Grid region measure up? Should you upgrade all your Interactive Reports and tabular forms now?<<CHR(10)>><<CHR(10)>>Attend and find out.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Tools',NULL,NULL,NULL,'Blaine Carter','Oracle Corporation',NULL,'Track-a-Watt: Modify a Power Usage Tracker to Log Your Power Usage in a Database',REPLACE('If you''re like me, you use way too much power and you re not quite sure where. Tracking your power usage is a great start, but analyzing the data is often easiest when it''s in a database. Having to type it in by hand would be a pain; let''s void a warranty instead!','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Data Integration','Data management/integration',NULL,NULL,NULL,'Michael Casey','Oracle Corporation',NULL,'On-Prem to EPM Cloud (Hybrid) and Cloud-Only-Based Integration Solutions',REPLACE('This session will explain the integration options for EPM cloud services, when source data resides on-premise or in the cloud. Examples of hybrid integration will be shown where data from on-prem sources such as an ERP or data warehouse can be loaded to the cloud, drilled from the cloud back to on-prem, and extracted from the cloud for use in other on-prem applications. In addition, solutions to move data between EPM Cloud services and between the Fusion GL Cloud and EPM services will be explained. Details related to current features and product roadmap will also be provided.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Other Application Express',NULL,NULL,NULL,'Nathan Catlow','Recx Ltd',NULL,'Securing Oracle APEX: Cross-Site Scripting',REPLACE('Understanding the areas in Oracle APEX that typically result in security problems is essential to building robust solutions. This talk will take an in-depth look at cross-site scripting, undoubtedly the most prolific problem facing APEX applications today. We will be demonstrating the security impact of insecure applications as well as required fixes based on real-world examples.<<CHR(10)>><<CHR(10)>>The power of cross-site scripting attacks are regularly underestimated. In this session, we will demonstrate complex cross-site scripting attacks against APEX applications and use API calls and item settings to ensure the data within your APEX applications remains secure.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Infrastructure','Other EPM Infrastructure',NULL,NULL,NULL,'John Ceynar','Halliburton',NULL,'Hyperion Disaster Recovery: Prepared for Sharknado or Whatever',REPLACE('Hyperion applications are often a critical component of a company s closing and reporting process and needs to be quickly recovered in the event of a disaster. I ll review options for disaster recovery and talk about restoring specific Hyperion components and shortcuts to be up and running faster.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Planning','Cloud Technologies - PBCS & EPBCS focused',NULL,NULL,NULL,'Mohan Chanila','Performance Architects','Chuck Persky, Performance Architects','Cloudy with a Chance of PBCS: Tips and Tricks for Migrating On-Premise Oracle Hyperion Planning to Oracle Planning and Budgeting Cloud Service (PBCS)',REPLACE('Many organizations have made the switch from an on-premise Oracle Hyperion Planning solution to Oracle Planning and Budgeting Cloud Service (PBCS). This move allows them to take advantage of the benefits that exist in an Oracle SaaS model and some of the newer features available in PBCS. However, many other organizations, while very interested, are hesitant to make this leap, in fear of the unknown and the potential process involved in migrating to this model. In this session, you will learn from industry experts about a variety of considerations, tips, and methodologies utilized in planning and executing this type of change. Specifically, this session will explore the dynamics of this migration through real-life examples, including the steps for assessing the current application(s), decisions surrounding a "lift and shift" versus a "rebuild" approach, the process for executing the migration, and how to acclimate system administrators and users to a PBCS (cloud) methodology and interface. Additionally, this session will explore the facets of data integration and security; how these capabilities may be the same or different than the current on-premise model; and how to build a strategy to successfully create these capabilities in PBCS. Please join us in navigating from the ground to the cloud.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','Financial Reporting',NULL,NULL,NULL,'Jay Chapman','Vertical Edge Consulting Group',NULL,'Public Sector Financial Reporting Is a Breeze as a Government Agency Takes a Walk in the Cloud with PBCS and EPRCS',REPLACE('By now, we know all about the wonders of Oracle''s Enterprise Performance Reporting Cloud Services and Planning and Budgeting Cloud Services. But have you seen how they are both utilized in the public sector? Join us to learn how Bell County went from Excel spreadsheets to successfully creating their comprehensive annual financial report by using Oracle PBCS and EPRCS. Along with the case study, the session will also include best practices for integrating EPRCS and review the latest features from the most recent update.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Financial Close','HFM',NULL,NULL,NULL,'Ray Chontos','Finit Solutions','Kathleen Marschak, Adient','How to Successfully Set Up an HFM Environment for a New Spinoff Company',REPLACE('Spinoffs are a common practice, as companies continually adapt to new and different markets. In 2016, Johnson Controls   a company with one of the largest and most complex HFM environments in the world   spun off a $17B portion of its business into a new, independent company. Learn how that newborn company, Adient, successfully designed and deployed HFM applications to meet revised reporting requirements, and satisfy a new CFO and over 1,300 HFM users. This session will walk through the critical actions and lessons learned as the JCI HFM team members transformed their systems and themselves into Adient and helped this huge and hectic spinoff to roll out as smoothly as a stroll down the River Walk.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Dev',NULL,NULL,NULL,'Maria Colgan','Oracle Corporation',NULL,'Explaining the Explain Plan: Interpreting Execution Plans for SQL Statements',REPLACE('The execution plan for a SQL statement can often seem complicated and hard to understand. Determining if the execution plan you are looking at is the best plan you could get or attempting to improve a poorly performing execution plan can be a daunting task, even for the most experienced DBA or developer. This session examines the different aspects of an execution plan, from selectivity to parallel execution, and explains what information you should be gleaming from the plan and how it affects the execution. It offers insight into what caused the Optimizer to make the decision it did as well as a set of corrective measures that can be used to improve each aspect of the plan.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DBA',NULL,NULL,NULL,'Maria Colgan','Oracle Corporation',NULL,'The Future of Database',REPLACE('Database architectures are fundamentally changing due to new technologies and new requirements. Organizations must understand and embrace these transformations to thrive in the future. This has never been more evident than with Oracle Database 12c, which has been the most rapidly adopted release in over a decade. This session provides a technical introduction to what''s new in Oracle Database 12c and explains how you can embrace each transformation while preserving your existing investments.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Design',NULL,NULL,NULL,'Dave Collins','The Hackett Group',NULL,'Empowering Management Reporting via Oracle Essbase',REPLACE('Microsoft XL remains the leading business tool for analysis, management reporting, and even ETL! Why? Well, XL is easy and everyone knows how to use it   or do they? In today''s ever-changing world, speed-of-thought analytics ensure success. Data modeling via OLAP is certainly one way to empower users. During this session, you will see how easy it is for business users to model, update, and perform analyses with XL and more formalized reporting tools. You will also learn the best-practice approach for enabling both self-service and structured reporting.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Calculation',NULL,NULL,NULL,'George Cooper','Gap',NULL,'Advanced Calculation Techniques: Going Beyond the Calc Dim',REPLACE('Join us as we take a deep dive into some of the ways the Essbase calculation engine can be used to solve complex business problems, all derived from real-life examples learned from the school of hard knocks. Techniques include combining spreadsheets and calc scripts to compute variances for hundreds of member combinations, designing recursive calculations to analyze a product s components, and building a structure that allows user input to any level of a hierarchy. We ll review the different methods of writing allocations, ways to optimize your parallel calculations, and block creation techniques and calculation features you are told  never to use  but might want to use anyway. This presentation is intended for intermediate Essbase developers, but all are welcome.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Data Integration','Data management/integration',NULL,NULL,NULL,'Doug Correa','Peloton Group','Michael True, Velcro Group Corp.','Velcro and FDMEE: One Data Management Solution for EPM Cloud and On-Prem Systems',REPLACE('When Velcro embarked on its EPM journey, it elected a hybrid approach, using Oracle s cloud and on-premises applications PBCS and HFM.  <<CHR(10)>><<CHR(10)>>Next, Velcro needed a data management solution that could support integrations to both cloud and on-prem EPM applications, pull data directly from ERP systems, and easily transfer data between EPM apps. Velcro chose FDMEE 11.1.2.4.<<CHR(10)>><<CHR(10)>>This customer success story will focus on how Velcro used FDMEE s advanced features to simplify and enhance its EPM planning and reporting processes','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Financial Close','Other Financial Close',NULL,NULL,NULL,'Julien Coudrette','Grant Thornton','Vinay Nagareddy, Wilsonart International','Fast, Effective, and Successful HTP Implementation at Wilsonart',REPLACE('While most finance functions are equipped with Financial consolidation and reporting systems, many tax departments are still relegated to Excel silos, struggling with manual processes and disconnected from the information flows.<<CHR(10)>> <<CHR(10)>>In 2016, Wilsonart successfully implemented Hyperion Tax Provision, in partnership with Grant Thornton. The implementation answered the specific needs for automation and reporting of the tax department, and integrates with a broader state-of-the-art Finance Systems architecture with direct feeds from the multiple ERPs and HFM.<<CHR(10)>> <<CHR(10)>>Wilsonart can prepare its tax provision confidently and is now well-positioned to handle future growth. This session will present why and how Wilsonart implemented HTP and the benefits attained after a year-end and a few quarter closes.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','MDX',NULL,NULL,NULL,'Gary Crisci','General Electric',NULL,'I''ve Got an MDX Script for That',REPLACE('With the release of Essbase 11.1.2.4.010, it is now possible to get clean MDX output from a MaxL script. This opens many doors and possibilities for developers and power users, and makes knowing how to write a solid MDX script a must-have skill for Essbase professionals.<<CHR(10)>><<CHR(10)>>In this session, EPM Principal Technologist and Oracle ACE Gary Crisci will discuss the fundamentals of writing MDX scripts. He will introduce the new delimited output options and discuss different ways to leverage this new feature. Gary will show attendees how they can use their MDX scripts to create advanced reports for users and how to format data for ingestion to other systems. Gary will also discuss how to use the Query & Load (Q&L) method to leverage MDX scripts as an alternative to ASO calc scripts. Don t miss this informative session from a noted MDX expert.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Planning','Cloud Technologies - PBCS & EPBCS focused',NULL,NULL,NULL,'Gary Crisci','General Electric','Shyam Nath, General Electric','Cloud2Cloud   IoT and EPM: Connecting GE s Predix Industrial Internet Cloud Platform to Oracle s Planning and Budgeting Cloud Service (PBCS)',REPLACE('The Internet of Things (IoT), also known as the Industrial Internet, is changing the way industries work. By combining machine-to-machine (M2M) communication, industrial big data analytics, technology, cybersecurity, and automation, it s driving new levels of efficiency and productivity.  <<CHR(10)>><<CHR(10)>>What if you could predict events before they happened? By connecting machines, gaining operational visibility, and leveraging analytics, you can drive operations to their fullest potential and predict what will happen before it occurs.<<CHR(10)>><<CHR(10)>>GE s Predix platform is a cloud-based solution that can capture industrial data. Now that you have this valuable information, how do you get it in the hands of the people who need it and in a tool that allows them to use the information to make better decisions?<<CHR(10)>><<CHR(10)>>In this presentation, Gary Crisci, Principal Data & Information Architect, Shyam Nath, Partner Account Director, and Venkat Kailasam, Senior Data & Information Architect, will walk you through the Internet of things (IoT). We will illustrate how we capture industrial data from sensors using GE s Asset Performance Management SaaS cloud solution to determine leading indicators of when large maintenance events are likely to be due and what the nature of the maintenance required will be. Lastly, we will demonstrate how to transfer the data into an Oracle PBCS cloud application for Planning and Budgeting purposes.<<CHR(10)>><<CHR(10)>>Come learn about the next great frontier in information technology and how we are leveraging EPM and IoT to drive better business decisions.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Other Application Express',NULL,NULL,NULL,'Martin D''Souza','Insum',NULL,'Explore the APEX APIs',REPLACE('Most developers new to APEX aren t aware that APEX comes with a plethora of very powerful APIs for both PL/SQL and JavaScript. This presentation will highlight some of these APIs and explain how and when to use them to speed up and simplify developing your APEX applications. New 5.1 APIs will also be discussed.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Dev',NULL,NULL,NULL,'Martin D''Souza','Insum',NULL,'Open-Source PL/SQL Utility Tools for Oracle',REPLACE('OOS Utils is a free open-source PL/SQL tool set for common utility functionality that developers use. Its goal is to prevent developers from having to rewrite the same code over and over again.<<CHR(10)>><<CHR(10)>>This presentation will highlight some of the great features of OOS Utils and showcase some future plans for the project. All audience types (DBAs, PL/SQL and APEX developers, and Development Managers) are encouraged to attend, as all will see immediate benefits for themselves or their teams to use.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Planning','Cloud Technologies - PBCS & EPBCS focused',NULL,NULL,NULL,'Manish Daga','Oracle India Pvt. Ltd.',NULL,'Configuring EPBCS for Operational Planning Requirements',REPLACE('This session will talk about the challenges/requirements for Operational Planning and how you can configure EPBCS to address these challenges/requirements.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Data Integration','Metadata management/integration',NULL,NULL,NULL,'Steven Davis','TopDown Consulting',NULL,'DRG: Creating Workflows in DRM',REPLACE('Data governance continues to be a big topic. Regardless of company size, at some point a growing organization decides to implement workflow in order to capture the changes you need to make to the master data. This is where DRG comes in. In this session, Steven Davis, DRM and DRG expert, will show you how to create collaborative workflows in DRG. He will look at workflow models, requests, paths, tags, worklists, tasks, models, filters, and users. He will show you how to:<<CHR(10)>>&bull;  Create models and tasks<<CHR(10)>>&bull;  Build workflow objects<<CHR(10)>>&bull;  Auto number your new accounts and create validations on the workflow<<CHR(10)>>&bull;  Assign security to the users and hierarchies<<CHR(10)>>&bull;  Separate duties and do conditional workflows<<CHR(10)>>&bull;  Filter nodes<<CHR(10)>>&bull;  And more<<CHR(10)>>The session will include real-world examples as well as tips, tricks, and best practices for working collaboratively with DRG to make sure all users have the necessary change management and data quality remediation workflows to effectively do their jobs. NOTE: Attendees should have a good understanding of DRM. They should understand what workflow is and how it is used.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Real World',NULL,NULL,NULL,'Niels de Bruijn','MT AG',NULL,'Getting Your Grips on Excel Chaos',REPLACE('If historically grown Excel mess in your company sounds familiar to you, then this session is for you. Based on real-world projects, learn how APEX can save end users a lot of time, how the migration is done, and what the strengths/weaknesses of APEX are, as opposed to Excel.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Real World',NULL,NULL,NULL,'Niels de Bruijn','MT AG',NULL,'This Is How We Do It',REPLACE('Different kinds of APEX projects lead to different implementation techniques. Let us classify the project types we had in the past and how we dealt with them, not only from an implementation standpoint but also in how we interacted with our customer.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Planning','Optimization',NULL,NULL,NULL,'Ludovic De Paz','TopDown Consulting','Ron Moore, TopDown Consulting','Extreme Calc Manager',REPLACE('Calc Manager is at the center of Oracle s EPM suite. It s the place to develop logic for Essbase, HFM, and Planning on-premise or in the cloud. It s chock full of advanced features, and it s quite a task to master all of them. That s where we come in. Join Ludovic De Paz, TopDown Consulting Senior Manager, and Ron Moore, TopDown Consulting Solutions Architect, for a deep dive into some of the more advanced features of Calc Manager.<<CHR(10)>><<CHR(10)>>We will focus on features that save time and/or allow developers to do things they otherwise couldn t do and explore:<<CHR(10)>>&bull;  How to take advantage of Calc Manager s modular nature to develop rules and rule sets quickly and benefit from reusability  <<CHR(10)>>&bull;  All types of variables and some advanced variable tricks<<CHR(10)>>&bull;  How to troubleshoot using the debugger, error messages, and logs (especially with the cloud) <<CHR(10)>>&bull;  How to use Custom Defined Templates to adapt your rules to different outlines and applications<<CHR(10)>>&bull;  How to use Custom Defined Functions <<CHR(10)>><<CHR(10)>>This session promises to satisfy the most geeky of you, and with several real-life stories and demos you will be able to take your Business Rules to the next level.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Data Integration','Other EPM Data Integration',NULL,NULL,NULL,'Rodrigo de Souza','Dell','Ricardo Zoldan Giampaoli, Sr, TeraCorp','Data Warehouse 2.0: Master Techniques for EPM Guys (Powered by ODI)',REPLACE('EPM environments are generally supported by a Data Warehouse; however, we often see that those DWs are not optimized for the EPM tools. During the years, we have witnessed that modeling a DW thinking about the EPM tools may greatly increase the overall architecture performance.<<CHR(10)>><<CHR(10)>>The most common situation found in several projects is that the people that develops the data warehouse does not have a great knowledge about EPM tools and vice-versa. This may create a big gap between those two concepts which may severally impact performance.<<CHR(10)>><<CHR(10)>>This session will show a lot of techniques to model the right Data Warehouse for EPM tools. We will discuss how to improve performance using partitioned tables, create hierarchical queries with  Connect by Prior , the correct way to use Multi-Period tables for block data load using Pivot/Unpivot and more. And if you want to go ever further, we will show you how to leverage all those techniques using ODI, which will create the perfect mix to perform any process between your DW and EPM environments.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Planning','Other Planning',NULL,NULL,NULL,'Brian Deegan','Peloton',NULL,'Discover a Brave New World of Key Metric Analytics: Unlocking the Power of Planning and Reporting Through ASO',REPLACE('Industry-leading organizations analyze key metrics on a daily basis to assess company performance. For many organizations, reporting these key performance indicators can be time-consuming, require manually aggregating data from multiple sources, and possess the real concern of data accuracy. By unlocking the power of ASO, companies now have dynamic access to their company s key metrics that were previously challenging to analyze. Critical financial planning processes such as daily sales reporting and workforce expense analysis are some of the specific examples that will be demonstrated to show how these ASO reporting solutions were integrated with the planning process to provide a wealth of analytics. In this presentation, we will provide examples of the innovative ways companies have leveraged the capabilities of ASO to directly support their financial planning processes, increase reporting performance, and provide greater insights into their important operational metrics.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Business Content','Budgeting and Planning Processes',NULL,NULL,NULL,'Natalie Delemar','Ernst & Young',NULL,'Trends and Hot Topics in Finance for the EPM Professional',REPLACE('According to CFO Magazine,  As much as technology influences the CFO role today, it may define the job in five years.  The office of the CFO has been accused of lagging behind other functional areas in leveraging technology and innovation in their operations. This session will focus on the trends and innovations specifically in FP&A and how technology can be an enabler to your client or company becoming a leading finance organization. Hot topics in FP&A will be covered including drivers, predictive analytics/machine learning, role-based reporting, visualizations, and zero-based budgeting.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Data Warehousing & Big Data','Data Architecture',NULL,NULL,NULL,'Jean-Pierre Dijcks','Oracle Corporation','Stewart Bryson, Red Pill Analytics','Architecture Live: Designing an Analytics Platform for the Big Data Era',REPLACE('Don''t miss the Architecture Live experience! In this interactive session, you''ll witness two industry experts digitally illustrating data-driven architectures live, with input and feedback from the audience.<<CHR(10)>><<CHR(10)>>Kafka, Lambda, and Streaming Analytics will be all covered. We ll tell you what these words mean and more importantly how they affect the choices we make building an enterprise architecture. With the Oracle Information Management Reference Architecture as the backdrop, we''ll clarify and delineate the different components involved in delivering big data, fast data, and all the gray area in between. The Architecture Live experience will be fun and different, and we''ll all learn something along the way.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','Other Database',NULL,NULL,NULL,'Jonathan Dixon','Cloud Nueva',NULL,'Alexa! How Do You Work with Oracle REST Data Services?',REPLACE('At first glance, Artificial Intelligence (AI) may seem beyond the reach of the citizen ORDS developer. With companies such as Amazon, Google, and Apple providing the interface (aka Alexa, OK Google, and Siri), however, this is no longer the case. In this session, I will demonstrate how you can use Oracle REST Data Services (ORDS) as the gateway to and the Oracle Database as the engine behind Alexa skills that will impress your customers. Alexa! How many orders were placed in the past hour? Alexa! Are there any stuck transactions in ERP Cloud? Alexa! It''s time to make ORDS and the Oracle Database cool!','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Integration',NULL,NULL,NULL,'Kai Donato','MT AG',NULL,'Managing Node.js Instances with Oracle APEX',REPLACE('You want to monitor and manage your Node.js instances using a tool you are already familiar with? One of the most famous frameworks for controlling Node.js instances will be shown integrated in Oracle Application Express. I will show you how to create, manage, and monitor your Node.js instances from an Oracle APEX application.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Integration',NULL,NULL,NULL,'Kai Donato','MT AG',NULL,'Professional JavaScript Error: Logging for Oracle APEX',REPLACE('Are you searching for the missing piece to perform a perfect start for developing with JavaScript in Oracle APEX? This is the right session for you.<<CHR(10)>><<CHR(10)>>You might be familiar with the built-in debugging features in Oracle APEX and searching for a way to debug JavaScript in a similar way. I will show you how I''m setting up my environment and how I enabled my applications to report all errors to the database instead of just printing it in the local browser console.<<CHR(10)>><<CHR(10)>>With this approach, we are able to create additional metrics for loading times and even specific function execution times. The best part of it: We are saving them to the database and show it in an additional analytics application in Oracle APEX! Attend this session to be best prepared for any JavaScript-related work in Oracle APEX.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','Design',NULL,NULL,NULL,'Julian Dontcheff','Accenture',NULL,'The Benefits and Simplicity of Oracle Cloud Infrastructure: IaaS',REPLACE('IaaS is the fastest-growing area of public cloud computing. Oracle Cloud infrastructure as a service with built-in security and high availability offers elastic compute, networking, and storage to help any company quickly reach both value and productivity out of the business. The presentation covers the benefits of Oracle IaaS over Amazon and Azure, and we show how fast and easy it is to set up IaaS services in the Oracle Public Cloud.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Financial Close','Financial Close Management (FCM, ARM, SDM)',NULL,NULL,NULL,'Geordan Drummond','Edgewater Ranzal','Dan Noon, United Health Services','Supplementing the Close Process at UHS',REPLACE('Oracle s Supplemental Data Manager (SDM) module is designed to capture supplemental information in a structured process. Join us for a discussion on how UHS was able to replace a long list of Excel-based schedules with SDM and automate the data population to make the process more efficient. UHS was able to accommodate schedules used both at the beginning of the close process in order to formulate and validate accruals as well as at the end of the close process for reporting purposes.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Data Visualization & Advanced Analytics','Oracle Data Visualization',NULL,NULL,NULL,'Mike Durran','Oracle Corporation','Stewart Bryson, Red Pill Analytics','Expanding Your Data-Driven Story: The Next Chapter',REPLACE('Oracle Data Visualization (DV) makes it easy to get insight from your data. This stunningly visual and intuitive product enables you to access, blend, and wrangle a variety of sources   including spreadsheets, databases, and applications   and tell the story of your data. In this session, learn about the power of data storytelling and the latest capabilities of Oracle DV (including details of product roadmap) to create compelling analytic narratives, including how you can rapidly apply advanced analytic techniques to gain insights previously only accessible to advanced users. Learn about how Oracle DV has been used in real-life scenarios to gain insight and improve business performance.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Planning','Design',NULL,NULL,NULL,'Cindy Eichner','Finit Solutions',NULL,'Fluctuating Exchange Rates Causing Heartburn in the Planning Process?',REPLACE('Exchange rates movement can significantly impact budgets and forecasts. Let s explore currency translation in Hyperion Planning, including out-of-the-box multicurrency applications, custom currency translation options, and different ways to quantify and analyze the impact of exchange rate movement during the budgeting and forecasting processes. We will examine several solutions being used in production environments and examine why and how they were built to provide for a positive user experience while minimizing administration complexity. Leave this session knowing about other design options available for currency translation and quantifying the impact of exchange rates movement in Hyperion Planning applications.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Planning','Cloud Technologies - PBCS & EPBCS focused',NULL,NULL,NULL,'Cindy Eichner','Finit Solutions',NULL,'Minimizing Hyperion Planning and PBCS Administration Tasks by Design',REPLACE('Is your Planning administrator taking an inordinate amount of time to switch from one planning cycle to another? Are there just too many forms in your application? Do users have to wait for a process to be run to complete their tasks? Learn about different ways to reduce the time needed to administer applications, including Valid Intersections, form and business rule design with substitution variables, Smart Push, and other time-saving design options. Leave this session knowing how to implement these options in Hyperion Planning and PBCS applications.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Data Warehousing & Big Data','Other',NULL,NULL,NULL,'Zohar Elkayam','Brillix-DBAces',NULL,'Things Every Oracle DBA Needs to Know About the Hadoop Ecosystem',REPLACE('Big data is one of the biggest buzzwords in today''s market. Terms such as Hadoop, HDFS, YARN, Sqoop, and non-structured data have been scaring DBAs since 2010, but where does the DBA team really fit in?<<CHR(10)>><<CHR(10)>>In this session, we will discuss everything database administrators and database developers need to know about big data. We will demystify the Hadoop ecosystem and explore the different components. We will learn how HDFS and MapReduce are changing the data world and where traditional databases fit into the grand scheme of things. We will also talk about why DBAs are the perfect candidates to transition into big data and Hadoop professionals and experts.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Dev',NULL,NULL,NULL,'Zohar Elkayam','Brillix-DBAces',NULL,'Exploring Advanced SQL Techniques Using Analytic Functions',REPLACE('Even though DBAs and developers are writing SQL queries every day, it seems that advanced SQL techniques such as multidimension aggregation and analytic functions still remain relatively unknown. In this session, we will explore some of the common real-world usages for analytic function and understand how to take advantage of this great and useful tool. We will deep dive into ranking based on values and groups, understand aggregation of multiple dimensions without a group by, see how to do inter-row calculations, and much more.<<CHR(10)>><<CHR(10)>>Together, we will see how we can unleash the power of analytics using Oracle 11g best practices and Oracle 12c new features.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Data Warehousing & Big Data','Data Modeling',NULL,NULL,NULL,'William Endress','Oracle Corporation',NULL,'Analytic Views: A New Type of Database View for BI and Data Warehousing',REPLACE('Analytic views are a new type of view in Oracle Database 12c Release 2 that organize data for simplified access via SQL, extend data sets with aggregate data and measure calculations, and provide a rich metadata layer to support BI applications. In this session, learn how analytic views embed joins and aggregation rules, and measure calculations and navigation paths into a single view that is queried with very simple SQL. Use cases include simplifying access to data star schema, Oracle Big Data SQL, and JavaScript Object Notation and as an alternative to exporting data for the analysis in spreadsheets.<<CHR(10)>><<CHR(10)>>This session will be of particular interest to data warehouse architectures and developers and Business Intelligence application developers.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Financial Close','HFM Foundation Components',NULL,NULL,NULL,'Eric Erikson','PQR Company',NULL,'Back to the Future: EPMA to Classic Migration with HFM',REPLACE('It is "Back to the Future" time at Kscope17. EPMA used to be the future for EPM metadata maintenance. But what if you''re now implementing DRM or want to migrate the EPM environment onto Exalytics? Were shared dimensions and data synchronization ever used? This presentation walks through the steps of migrating an HFM EPMA application to Classic   the new future.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Real World',NULL,NULL,NULL,'Erik Espinoza','Viscosity North America','Jason Canada, Viscosity North America','Performant Faceted Search Navigation in APEX with Oracle JET and PL/SQL Table Pipelines',REPLACE('Faceted navigation is arguably the most significant search innovation of the past decade. Leveraged by retail sites including Amazon, Home Depot, and Zappos, faceted search allows users to quickly narrow a massive result set by giving them guides (the facets) of the major groups of their results. In this session, we discuss both thick and thin ways of doing this, from enterprise applications such as Oracle Endeca to simple methods using PL/SQL pipelined functions. We show you a retail use case and PL/SQL faceted database search, APEX application, and Oracle JET extensions.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','ADF and MAF',NULL,NULL,NULL,'Eugene Fedorenko','eProseed NL',NULL,'Life on a Loop: Close Look at Oracle ADF Page Lifecycle',REPLACE('This session focuses on the fundamental basis of Oracle Application Development Framework (Oracle ADF) and takes a deep dive into Oracle ADF page lifecycle. Come  finally understand the difference between "prepare model" and "render model." Learn what happens behind the scenes when a typical Oracle ADF page is requested from a browser. Hear how Oracle ADF extends standard JSF lifecycle and see what working horses the framework uses for that. The session provides a sample application to explain deeply every single phase of the lifecycle. Learn how to extend and customize Oracle ADF lifecycle in your application.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','ADF and MAF',NULL,NULL,NULL,'Eugene Fedorenko','eProseed NL',NULL,'Run a Successful Development Project in the Cloud with Oracle Developer Cloud Services',REPLACE('Got a project and a team of Oracle Application Development Framework (Oracle ADF) developers? Struggling to put together lots of things such as source control management, issue tracking, continuous integration, and Wiki collaboration? Come see how Oracle Developer Cloud Service helps cope with all that, basing on real-life experience. Learn how to develop, deploy, and collaborate with Platform as a Service (PaaS) development environment for the enterprise. Hear how to make the right decisions and how to organize the process, ensuring completion of the project on schedule and within budget.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Business Content','EPM/BI Strategies',NULL,NULL,NULL,'Elizabeth Ferrell','Kroger',NULL,'Did You Know Your Local Grocer Uses Essbase?',REPLACE('Kroger is scaling Oracle Hyperion Essbase to 25,000 users and putting timely data in the hands of the tactical resources in thousands of stores. Stores can drill through to invoices, write back their labor estimates, and manage allocation factors that are critical to corporate through the Dodeca interface.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Dev',NULL,NULL,NULL,'Steven Feuerstein','Oracle Corporation',NULL,'Change Impact Analysis with 12.2 PL/Scope',REPLACE('PL/Scope, first introduced in 11.1, offers a powerful code analysis tool, baked right into PL/SQL. With it, you can answer questions such as, "Where is this variable modified in my code?" "Which packages invoke a specific overloading of a function?" and "Show me all my unused declarations." Cool stuff. But prior to 12.2, SQL statements were not a part of that analysis. Now in 12.2, PL/Scope also gathers information about static SQL statements and where dynamic SQL is executed in your code. As a result, you can now use PL/Scope to perform comprehensive, detailed analysis of the impact of planned changes to your code base. In this session, Steven Feuerstein introduces attendees to PL/Scope, explores 12.2 enhancements, and provides scripts everyone can use to leverage PL/Scope in their dev environment.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Dev',NULL,NULL,NULL,'Steven Feuerstein','Oracle Corporation','Bryn Llewellyn, Oracle','Optimizing PL/SQL for Performance and Maintainabiliity',REPLACE('After fully leveraging SQL in your Oracle Database applications, it s time to completely utilize PL/SQL to implement business rules, create APIs on top of your data structures, and implement key processes within the database. Usually when developers think about optimization, they focus on performance, and this session does, too. But it s also critical to think about how to write code today so that tomorrow and years from now, future developers will be able to adapt that code to changing user requirements and database features. In this session, PL/SQL experts, including Bryn Llewellyn and Steven Feuerstein, will present their ideas on writing optimal PL/SQL but focus mainly on answering questions from the audience.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Dev',NULL,NULL,NULL,'John Flack','Self',NULL,'Updatable Views to Secure Your Database and Make Your Developers Happy',REPLACE('Learn about the advantages of putting updatable views between your applications and your tables. They can simplify development, enforce business rules, and provide extra security. And I will show you how to write INSTEAD OF triggers that make it all possible.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Planning','Cloud Technologies - PBCS & EPBCS focused',NULL,NULL,NULL,'Courtney Foster','interRel Consulting',NULL,'Jumpstarting Your Cost Allocations with Profitability and Cost Management Cloud Service (PCMCS)',REPLACE('Come learn how Oracle Profitability and Cost Management Cloud Service gives you a clear and definitive look into your business health. One of Oracle s newest cloud services takes its sister on-premises product, HPCM (Management Ledger applications), and launches it into the cloud with new and improved features. PCMCS provides a complete graphical interface to simplify the build and execution of complicated allocation rules all in the common EPM Cloud SUI (no scripting required!). Some beloved HPCM features come over, such as the traceability interface and rules balancing report, along with new pre-built dashboards. PCMCS sits entirely on top of Essbase and supports any costing methodology. There is no black box with PCMCS, as this cloud solution allows users to get an inside look at the drivers of costs as they  audit  the profitability of their organization. Learn how PCMCS can help you allocate expenses and get a better understanding of profit and costs at any level in your organization in less than two months.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Infrastructure','Cloud and Hybrid Infrastructure',NULL,NULL,NULL,'Bill Fox','Oracle Corporation',NULL,'Understanding EPM Cloud Infrastructure: What''s New?',REPLACE('New to EPM Cloud and want to know the ins and outs of managing your service? Then this is the session for you. Topics include service provisioning, backup and restore, security and user management, and service maintenance. This is the one-stop destination to orient you with everything you need to know about the operational aspects of working with EPM Cloud.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','OBIEE',NULL,NULL,NULL,'Jerome Francoisse','Rittman Mead',NULL,'Reduce European Flight Delay: Real-Time ODI, OBIEE, and D3',REPLACE('Eurocontrol is the European Organisation for the Safety of Air Navigation and works with 41 member states. An accurate view of the real-time traffic is needed in order to support its goal to reduce the average delay per flight in European airspace. Air traffic managers now have access to a new tool to efficiently visualize where problems could occur through the day and apply regulations where needed. In this session, we will first see how its data is refreshed every few minutes using web services integrated in Oracle Data Integrator. Then we will look at the tool itself, powered by Oracle Business Intelligence Enterprise Edition, and some advanced visualization build in D3 to follow an aircraft through all its flights of the day.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Data Visualization & Advanced Analytics','Other',NULL,NULL,NULL,'Holger Friedrich','sumIT AG',NULL,'Oracle R Enterprise and Data Visualization: Combining Their Power Leads to New Possibilities',REPLACE('In advanced analytics, the R language with its different distributions became the de facto standard in recent years. In visualization, tools such as Oracle Data Visualization, QlikView, and Tableau for data exploration and flexible analyses are spreading rapidly. However, using data viz tools interactively on top of advanced analytics such as R is often hard because either they lack integration or the performance of R installations is just not good enough for interactive analyses or computation of massive data sets on a regular, e.g. nightly, or even an ad hoc basis. This problem can be solved by combining the use of Oracle Data Visualization (Data Viz) and Oracle R Enterprise (ORE). While ORE can run directly on large database servers, making full use of their massive computational power and parallel execution of R code, Data Viz offers immediate access to analytic results and can string them together with all sorts of other data available for exploration and further analysis. This talk explains the concept and advantages of using ORE and Data Viz in combination. Live demonstrations will illustrate the solution. Attend to get inspirations for solutions to your own business challenges and projects.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Financial Close','HFM',NULL,NULL,NULL,'MIchael Fuori','GE',NULL,'HFM Performance Optimization: 10 Things That Can Save Your Application',REPLACE('Application running slower than you think it should? Afraid the application will slow over time? Not sure if it s an application problem or environment issue? Then join this session to hear about the HFM 11.1.2 performance optimization efforts of General Electric. See how GE has optimized one of the largest (16) dimension HFM applications and environments known to Oracle. We would tell you more, but then we would spoil the ending. Join us to see how it all turned out.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Financial Close','HFM',NULL,NULL,NULL,'MIchael Fuori','GE',NULL,'HFM Rules Automation: UDs and Triggers Gone Wild',REPLACE('Ever think you would see the day that an HFM rule file could be so dynamic that it virtually eliminated the need for maintenance? Well, at General Electric we have put UD fields on steroids and enabled triggers to achieve just that.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Other Essbase',NULL,NULL,NULL,'Daniel Gagnon','Huron Consulting Group',NULL,'Using VBA to Enhance the Smart View Expereince',REPLACE('Have you ever taken a look at the Smart View developers guide and seen all of the VBA functions that are available to you? They are endless, and the power they pack can be lost behind the sometimes-complex syntax that is required. Come spend an hour learning what they do, how they can benefit you, and possibly even how to accomplish tasks otherwise out of reach.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Other Essbase',NULL,NULL,NULL,'Tim German','Qubix','Cameron Lackpour, ARC EPM','Essbase Cloud   How You Do It (Live Demos) and Expanded Q&A',REPLACE('You won t want to miss this opportunity to see Oracle Essbase Cloud Service up close and personal.   Cameron Lackpour and Tim German will expand on their Essbase Cloud session, demonstrating how to accomplish a variety of real world tasks and use-cases in Essbase Cloud Service.   An Oracle representative will be on hand to weigh in on Q&A discussions.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Calculation',NULL,NULL,NULL,'Robert Gideon','interRel Consulting',NULL,'Essbase CDFs Demystified: Pulling Back the Curtain and Opening a World of Possibilities',REPLACE('Unique challenges often arise during Essbase and Planning projects that require thinking outside of the box, or the calculator engine, as the case may be. Essbase Custom Defined Functions (CDFs) enhance the calculation functions included with Essbase. Essbase CDFs unleash the power of Java and open a world of possibilities. This session will demystify CDFs, show how to deploy them, and demonstrate how they can be used if the need arises.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Other Application Express',NULL,NULL,NULL,'Dimitri Gielis','APEX R&D',NULL,'APEX for Beginners',REPLACE('If you''ve heard about APEX but didn''t play with it yet, or only played with it for a couple of weeks, this session is for you. My goal is to save you at least a month of searching and finding your way to build great APEX applications. I''ll share how to get started, where the APEX sweet spot is, and common pitfalls you should avoid.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Integration',NULL,NULL,NULL,'Dimitri Gielis','APEX R&D',NULL,'OMG! JavaScript Straight from the Oracle Database',REPLACE('When APEX and the core database features were not enough, I started to investigate how to run JavaScript straight from the database. My results were baffling   and I want to share them with you. I''ll explain how you can do it yourself and show many live demos where this new technique is useful.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','Other Database',NULL,NULL,NULL,'Tim Gorman','Delphix',NULL,'Accelerating Testing Using Data Virtualization',REPLACE('How much testing do you perform in your BI/DW environments? Do you even have a test environment? Do you test in production?<<CHR(10)>><<CHR(10)>>The biggest problem with testing in BI and DW environments is the size and velocity of data. Databases and applications have grown enormous and complex. "Storage is cheap" is simply not true. Need proof? Ask for 10 TB to provision a new test environment.<<CHR(10)>><<CHR(10)>>Provisioning a full environment for each developer or tester on each task of each project appears unrealistic, when each might require several terabytes or even petabytes of storage. And so everyone is limited to working in a small handful of shared environments that are refreshed only every few months, if ever, and both code quality and data quality suffer.<<CHR(10)>><<CHR(10)>>Data virtualization is the solution. Using thin-provisioning technologies, virtual databases and file systems only consume space from changed blocks, so it is possible to provision virtual terabytes for only a few actual megabytes. Coders and testers have full and independent read-write environments provided quickly in which to develop and test, improving code quality. Learn about the technical details behind this solution.<<CHR(10)>><<CHR(10)>>When I first heard about data virtualization, it sounded far-fetched, just a trick. Instead, it is the perfect solution to the perfect storm of more data quickly. Every IT shop will need to know how to provision test environments faster using less storage. It''s not a matter of "if," but "when.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DevOps/Agile',NULL,NULL,NULL,'Tim Gorman','Delphix',NULL,'Barriers to Oracle Database In IaaS Cloud',REPLACE('IaaS cloud vendors such as AWS prefer that everyone migrate to the cloud, but what often happens is that non-production migrates for cost reasons but production stays on-premises. This phased path to the cloud can leave IT with a split personality: production on-premises on legacy proprietary UNIX platforms, non-production in the cloud on commodity Linux platforms.<<CHR(10)>><<CHR(10)>>Because the security risk on non-production systems is much higher than production, there is a requirement to mask personally identifiable information or confidential data before it is copied to non-production. Data virtualization employs thin cloning, snapshots, and network-attached data presentation, reducing cloning from hours or days to minutes. But there is more: Your legacy UNIX (i.e. AIX, Solaris, HP-UX) databases aren''t going anywhere off-premises because the cloud is based on Intel (i.e. Linux, Windows). So what to do?<<CHR(10)>><<CHR(10)>>In this session, learn how data virtualization and data masking make "split-brain IT" not just possible but desirable.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Dev',NULL,NULL,NULL,'Kent Graziano','Snowflake Computing',NULL,'Top Five Cool Features in Oracle SQL Developer Data Modeler',REPLACE('Oracle SQL Developer Data Modeler is an industrial-strength data modeling tool that can be used for any data modeling task you need to tackle. Over the years, I have found quite a few features in the tool that I rely on to make me more efficient in developing my models. I will demonstrate at least five of these features, tips, and tricks including using the metadata export tool.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','SmartView',NULL,NULL,NULL,'Jennifer Guzik','Hudson Advisors',NULL,'Report Automation Techniques from Essbase and Hyperion Financial Reports with VBA and Smart View',REPLACE('Financial reporting packages sometimes need to be updated with current data multiple times per day during parts of the accounting close process. When your package covers hundreds of entities, streamlining and automating this process as much as possible is a high priority. In this session, we will discuss why we chose to use Excel and Smart View as our reporting platform to bring in Essbase data via HFR and direct Essbase queries and some tips on how we used VBA to make the process run with one click.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','Other BI and Reporting',NULL,NULL,NULL,'Jennifer Hanks','Key Performance Ideas',NULL,'Mastering MDX for Analytics and Reporting',REPLACE('MDX is often used in ASO cube member formulas, but did you know you can also use MDX to write reports and Smart View queries? Did you know that these reports and queries can be written against both BSO and ASO cubes? MDX can seem daunting, but with a basic understanding of syntax and functions, MDX is not that difficult. This session will give you what you need to get started writing MDX reports and queries that can supplement your reporting and add a new tool to your reporting tool set.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','Other Database',NULL,NULL,NULL,'Kim Hansen','Trivadis Danmark A/S',NULL,'Analytic Views in Oracle Database 12.2: The Virtual Cube',REPLACE('Traditionally to model and analyze your data with dimensions and hierarchies, either you copy your data to a data warehouse and from there to a dimensional cube, or you have to write quite a lot of rather advanced code and SQL to emulate the same directly on your relational data.<<CHR(10)>><<CHR(10)>>With analytic views (introduced in Oracle Database version 12.2), you declaratively define the dimensions and hierarchies similar to creating a cube, but it is only stored as a metadata layer on top of your tables; it is a multidimensional *view* of your relational data. The SQL language has been expanded to allow a simpler query syntax on the analytic views to utilize these metadata and automatically use advanced analytic functions to give you dimensional analysis on real-time data. As SQL is used below the covers, performance can be tuned using query rewrite with materialized views or In-Memory options or any other option you would normally use for SQL tuning.<<CHR(10)>><<CHR(10)>>This session will show code examples covering a lot of the syntax you have for creating and using analytic views.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Data Integration','Other EPM Data Integration',NULL,NULL,NULL,'Michael Hansen','Leidos','Trina Nguyen, Leidos, Inc','ASO Plan Type: To Seek Out New Integrations with ODI',REPLACE('Be prepared to be beamed up! In this session, you will embark on a voyage that an enterprise took utilizing ODI as its warp core to improve data integrity and efficiency, and reduce the cost of ownership of their EPM Planning and Essbase solution. There will be a brief overview of the ODI use case and how ODI was instrumental in achieving a self-service ASO Plan Type Solution. Discover how Leidos creatively utilized ODI for more than just metadata and data integration, including assisting with procedure calculations, dynamically generating business rules, launching calculations, building alt hierarchies from forms, data validations, and much more.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Planning','Other Planning',NULL,NULL,NULL,'Michael Hansen','Leidos','Trina Nguyen, Leidos, Inc.','ASO Plan Type: The Final Frontier',REPLACE('Seat backs in an upright position and buckle up! In this session, you will embark on a voyage from academic theory to a real-world deployment of an ASO Plan Type Solution. There will be a brief overview of use case and how a self-service approach for Planning led Leidos to select an ASO Plan Type Solution. Discover how Leidos tackled the challenges of an ASO Plan Type, enabling users to do all their planning directly in an ASO cube. Learn how Leidos overcame the obstacle of an Essbase data connection and finally satisfy the Vulcan in you with tips to take calculations to warp speed. ASO Planning can be an exciting new frontier for an enterprise in the real world.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Real World',NULL,NULL,NULL,'Roel Hartman','APEX Consulting',NULL,'Docker for Dummies',REPLACE('You might (or might not) have heard of Docker, but you have no idea what it is and why you should care. But if you are a Database or APEX developer and still work with Virtual Machines, it is about time to broaden your horizon.<<CHR(10)>><<CHR(10)>>In this session, you''ll learn what Docker is and how you can benefit from it in your daily work.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Integration',NULL,NULL,NULL,'Roel Hartman','APEX Consulting',NULL,'Make Your APEX Applications Fly Using JET Components',REPLACE('At Oracle OpenWorld 2015, Oracle introduced JET: JavaScript Extension Toolkit. APEX 5.1 ships with JET and uses it to create the good-looking charts declaratively. But if you know JET a bit better, you can tune the look and feel of the charts even more. And apart from the exposed charts, there are more components in JET you can use in your APEX application. This session will show you how to do that and walk through a way to create plugins for JET components.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Infrastructure','Security',NULL,NULL,NULL,'Jon Harvey','eCapital Advisors','Casey Ratliff, eCapital Advisors','Hacking Hyperion: A White-Hat Approach to Securing Your Instance',REPLACE('Because of its nature as a financial analysis system, Hyperion tends to house a company s most sensitive information (and a lot of it!). In spite of this, security is rarely a focus of many Hyperion implementations. In most areas of the suite, Hyperion is pretty good at securing itself. However, in a few glaring instances, there are default settings that leave you exposed. But don t panic   an ounce of prevention is worth a pound of cure!<<CHR(10)>><<CHR(10)>>Join eCapital Advisors  Jon Harvey and Casey Ratliff as they decrypt, disassemble, and walk through some of the back doors of the Hyperion infrastructure and how to secure them in your environment. Come learn about these exploits before your auditors do!','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','Other BI and Reporting',NULL,NULL,NULL,'Brian Haugabrook','Valdosta State University','Arthur Rinberger, Valdosta State University','Improving Insights and Analytics Using Oracle BI Cloud Services',REPLACE('Performance-based funding models for higher education institutions center the focus on improving student retention, progression, and graduation. Often the effort to track and improve relevant metrics is difficult. Leveraging the right BI platform to connect early alerts, predictive analytics, key performance indicators, reporting, and data visualizations is essential to being successful. This session will review how a university leveraged Oracle BI Cloud Services to streamline dashboard creation and implement data visualizations.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Detail Plunge',NULL,NULL,NULL,'Sabine Heimsath','its-people GmbH',NULL,'Know What Your Code Is Doing; Know What It''s Done: How to Instrument Your Code Easily and Effectively',REPLACE('Do you measure how your code is performing? Do you have the right info at hand when your program fails? Can you monitor your program while running?<<CHR(10)>><<CHR(10)>>This session is all about instrumenting your PL/SQL code, be it inside an APEX application or in a pure PL/SQL environment. What are the alternatives to the very common hand-knitted or organically grown solutions? We are going to look at a few open-source frameworks and analyze which requirements they can cover and what you might have to add yourself. After this session, you will know what to look for when choosing the right framework to enhance your project.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Tools',NULL,NULL,NULL,'Sabine Heimsath','its-people GmbH','Robert Marz, its-people GmbH','Six Reasons Why You Will Get Addicted to SQLcl Scripting',REPLACE('SQLcl is ready to replace the reliable but somewhat outdated SQL*Plus as the new command line interface of the database. The most exciting new feature of SQLcl is scripting: Batch scripts can now be written in languages such as JavaScript, Python, or Perl. This means a veritable cornucopia of options, many of which are not obvious at first sight.<<CHR(10)>><<CHR(10)>>After a brief introduction to SQLcl, we will show many real-world examples that demonstrate the new possibilities. All examples are available for download to allow for further tests and exploration. This presentation provides many in-depth live demos.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Data Visualization & Advanced Analytics','Oracle Data Visualization',NULL,NULL,NULL,'Antony Heljula','Peak Indicators Ltd',NULL,'Build your own Infographics using the Data Visualization SDK',REPLACE('Oracle Data Visualization has already made a huge impact with its excellent visualization and storyboarding features.    This session will demonstrate how to take these capabilities one step further by using the Data Visualization SDK.   The SDK provides the tools for developing your own custom visuals within Oracle Data Visualization, enabling you to deliver sophisticated infographics that can tell your stories in new and exciting ways!','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Business Content','EPM/BI Strategies',NULL,NULL,NULL,'Eric Helmer','Mercury Technology Group',NULL,'Unbiased Comparison:  Evaluating All Deployment Options for Hyperion EPM: SaaS vs. IaaS vs. On-Prem',REPLACE('Unbiased Comparison:  Evaluating All Deployment Options for Hyperion EPM: SaaS vs. IaaS vs. On-Prem<<CHR(10)>><<CHR(10)>>Today, the word "cloud" is everywhere, and it''s causing a lot of confusion.  Software as a Service (SaaS), Infrastructure as a Service (IaaS), and Platform as a Service (PaaS) are completely different solutions but are all considered "Cloud." <<CHR(10)>><<CHR(10)>>This session will compare and contrast the different available options Oracle customers have to deploy Oracle EPM.  It will break down all Oracles  Cloud offerings, Infrastructure as a Service, 3rd party hosting, traditional on-premise deployments including Exalytics, and Hybrid Approaches.  <<CHR(10)>><<CHR(10)>>This session will read between all marketing lines and discuss what s possible and what s a bit overstated.  It will cover differences in functionality, data integration, security, flexibility, and scalability.  Finally we will evaluate the differences in costs including hardware, software licensing, and on-going maintenance.  <<CHR(10)>><<CHR(10)>>If you are looking to make a decision on how best to deploy, upgrade, or outsource Oracle EPM this is a don t miss session. <<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Data Integration','Metadata management/integration',NULL,NULL,NULL,'Kate Helmer','Huron Consulting Group','Joe Davis, Huron Consulting Group','Best Practices of the Design and Delivery of Master Data from DRM to Downstream Applications for Large Implementations',REPLACE('Minimize maintenance and make delivering master data to your customers a breeze with the right design and methodology. Consuming master data from Oracle Data Relationship Management can be a convoluted mess of flat files (yuck!), tables, and technologies in a large enterprise   simplify and standardize by utilizing these design tips to creating a master data repository that can deliver and scale with ease. Join Joe Davis and Kate Helmer as they detail design considerations of master data repositories, the pros and cons of the methodology, and how to standardize the technical integrations to downstream systems.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','Design',NULL,NULL,NULL,'Heli Helskyaho','Miracle Finland Oy',NULL,'Design your databases using Oracle SQL Developer Data Modeler',REPLACE('Oracle SQL Developer Data Modeler is one of the leading database design tools in the market. The amount of data is growing and everybody is starting to understand the value of good quality data for their business. The only way to have good quality data and to understand your data is to design your databases. To be able to design them you need a tool, paper and pen is not enough anymore. What is database designing and how to design databases using Oracle SQL Developer Data Modeler?','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','Design',NULL,NULL,NULL,'Heli Helskyaho','Miracle Finland Oy',NULL,'How to design a database? Let''s start with the Logical Model',REPLACE('What is database designing and how to design a relational database? What is a Logical Design and why do I need to create one? What is NF3 and BCNF? Why would I care about all the theory and what is it by the way? During this session you will get answers to these questions plus about 100 more...','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Data Visualization & Advanced Analytics','Other',NULL,NULL,NULL,'Viet Hoang','California State University Los Angeles','Kirby Lunger, Performance Architects','Advanced Data Visualization Techniques Using Oracle BI Cloud Service (BICS): A Cal State Pilot Case Study',REPLACE('Join California State University (Cal State) to learn about how Cal State developed a pilot Oracle BI Cloud Service (BICS) solution with multiple subject areas across the institution so that their team can use advanced data visualization techniques to better analyze and report on college data.  During this session, we will demonstrate several visualization techniques that you can employ in your own organization to find that  needle in a haystack  to address your own burning business questions!  We will also discuss data integration techniques for both proprietary and third-party data sources, as well as how to organize for success; how to get a pilot project funded; and next steps for this initiative.<<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Business Content','EPM/BI Strategies',NULL,NULL,NULL,'Paul Hoch','TopDown Consulting','Steve Davis, TopDown Consulting','Hybrid Cloud   A Solution for a Business Problem',REPLACE('Moving EPM applications to the Cloud is the most significant market direction to date. The reality is that finance and IT teams don t move as fast as the applications, which means companies need a solution that accommodates a mix of on-premise and Cloud EPM applications (Hybrid Cloud). That solution is Hybrid Cloud. <<CHR(10)>><<CHR(10)>>A Hybrid Cloud implementation is not without its challenges, and because of this, companies find themselves asking:  What is the right the right approach and how do I make sure all my applications are seamlessly integrated?  In this session, Paul Hoch and Steve Davis, TopDown Consulting Principal Architects, will answer this question. They will discuss <<CHR(10)>><<CHR(10)>>&bull;  How Cloud offers compelling value to EPM owners e.g., beyond the obvious economic benefits<<CHR(10)>>&bull;  How to successful do a Hybrid implementation i.e., strategy for companies to combine on-premise and Cloud-based EPM systems<<CHR(10)>>&bull;  Review implementation considerations to ensure a powerful  hybrid  deployment<<CHR(10)>>&bull;  Integration and how it is critical to success<<CHR(10)>>&bull;  Common pitfalls and how to avoid them<<CHR(10)>>&bull;  Common scenarios where there is synergy for a  hybrid  deployment <<CHR(10)>>&bull;  Real-world examples of companies that are using a Hybrid approach what s working and what isn t<<CHR(10)>>&bull;  And more &<<CHR(10)>> <<CHR(10)>>This session is useful for anyone considering a Hybrid approach or those already with a hybrid approach.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Business Content','EPM/BI Strategies',NULL,NULL,NULL,'D.J.  Hoelscher','Oracle Corporation',NULL,'Current Trends and Best Practices for Improving User Adoption and Productivity for EPM and BI',REPLACE('In this session we will cover the current trends in learning and best practices for user training including similarities as well as differences between On-Premise and Cloud Users. We will also discuss how to overcome potential challenges and associated risks with user adoption. In addition the session will explore approaches to accelerating the development and deployment of effective User Training by leveraging available development tools or guided learning approaches.<<CHR(10)>>&bull;  User Training Best Practices<<CHR(10)>>&bull;  Cloud User Adoption Best Practices<<CHR(10)>>&bull;  User Adoption Challenges and Risks<<CHR(10)>>&bull;  End User Training Options<<CHR(10)>>&bull;  Explore approaches to accelerate development and deployment of training <<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Detail Plunge',NULL,NULL,NULL,'Menno Hoogendijk','Qualogy',NULL,'Plugin your APEX widgets',REPLACE('APEX 5.1 includes a lot of jQuery widgets and plugins under the hood.<<CHR(10)>>Since the development team use them to create our beloved components as the Interactive Report and Interactive grid, why not use the technique ourselves?<<CHR(10)>><<CHR(10)>>This session will demonstrate why widgets and plugins are so powerful. Did you know they can be exposed as APEX plugins to reuse them declarative? We''ll explore how some of the existing widgets work in order to build our own, step by step.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Other Application Express',NULL,NULL,NULL,'Menno Hoogendijk','Qualogy',NULL,'Powerful JavaScript skills for every APEX developer',REPLACE('Are you a developer looking for steady JavaScript skills? We all have to deal with the same issues sooner or later. Knowing about the most common features will help you solving issues and create advanced applications.<<CHR(10)>><<CHR(10)>>We''ll go over a lot of topics live: fundamentals, bad practices, their improvements and new features. The result? End up with professional, organised code.<<CHR(10)>><<CHR(10)>>This session is intended for beginner and intermediate developers. Join my talk and get an better understanding about the ever changing JavaScript landscape.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Financial Close','Financial Close Management (FCM, ARM, SDM)',NULL,NULL,NULL,'Joy Hsu','The Hackett Group','Charles J. Zorbach, Laureate Education','A lesson your teacher never taught you - Automated Account Reconciliations',REPLACE('To implement world-class financial close process and best practices, Laureate International Universities transformed from a manual reconciliation process to an integrated and automated process, using Oracle Account Reconciliation Management (ARM).  The solution rolled out to 6 shared service centers (SSC), including the US, Chile, Europe, Mexico and Brazil.  The solution automated data load with PeopleSoft GL and Subledgers to improve accuracy and accelerate the reconciliation process.  Overall automated reconciliations grew up to 50 %.  Automation enforces standardization across the reconciliation process and improves quality and accuracy of financial data.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Essbase-related technologies',NULL,NULL,NULL,'Philip Hulsebosch','Trexco b.v.',NULL,'Essbase and Crystal Ball: Adding risk related data to a Financial Model',REPLACE('In real estate development risk assessment and risk management are key elements for the financial model of a project. Common financial models only let you do a best case, worst case and most likely scenario. They lack information on the probability of occurrence of this most likely scenario. Also, information on the variance within this most likely scenario is often missing. This results in decisions based on inadequate information.<<CHR(10)>><<CHR(10)>>In this case study we will show an Essbase model and how to add risk related information. In a matter of hours we were able to extend the existing Essbase model with Oracle Crystal Ball statistical functionality and generate this important information.<<CHR(10)>><<CHR(10)>>This case study is about drilling a geothermal energy well and the green energy produced will be delivered to nearby apartments, houses and small businesses. The risk influencing factors were energy price, interest rate and maintenance costs. The case study can serve as a kind of blue-print on how risk related information can be added to a project plan.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Other Application Express',NULL,NULL,NULL,'Simon Hunt','MOD',NULL,'How to Use Apex to Build and Manage Automated Browser Tests',REPLACE('In this session, delegates will learn how to use Apex itself to build maintainable browser-based automation scripts for fast, consistent, repeatable testing of Apex applications.  All the products demonstrated are available through Open Source projects and there is no need for any specialist programming skills other than Apex.  Also covered is the ability to call the automation scripts programmatically and run them on a load testing environment or as part of an automated build process (AKA Continuous Integration).  The techniques shown will help developers become more Agile in their development and greatly improve the overall quality of their applications. <<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Business Content','EPM/BI Strategies',NULL,NULL,NULL,'Paul Husak','GE',NULL,'GE s EPM Shared Service Cattle Drive',REPLACE('See how GE organically built one of the largest EPM Shared Service teams. Long before building our Exalytics/Exadata PaaS supporting 500+ applications our team had much to round up.  Follow the journey west, dreaming under the stars of an EPM sky, building a vision, rustling businesses, corralling Oracle and multiple consultant teams, building platforms, processes and growing to meet demand. <<CHR(10)>><<CHR(10)>>Join me, Paul Husak Director of Architecture, through the forming, storming, norming and performing of an EPM Shared Service for one of the world s largest company s.  I ll share the risks and rewards associated with building a center of excellence, from building and all-star team, dealing with multiple vendors, establishing processes and absorbing new technology while keeping an eye on the Oracle cloud.<<CHR(10)>><<CHR(10)>>Technologies Highlighted: HFM, Planning, Essbase, CM, ARM, FDMEE, ODI, DRM, Automic, Accelatis, Exalytics, Exadata','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Exalytics',NULL,NULL,NULL,'Adrian Istani','Ingersoll Rand',NULL,'Essbase on Exalytics   It s magical if you chant the spells right',REPLACE('Essbase on Exalytics may / may not automatically translate better stability or performance without additional tweaking   in our case it did not. Here were our experience with Exalytics X3-4 since we acquired it in early 2015, moving from much smaller windows intel box to now rock solid implementation with Exalytics.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Dev',NULL,NULL,NULL,'Jeff Jacobs','Jeffrey Jacobs & Associates, LLC',NULL,'OMG! Identifying and Refactoring Common SQL Performance Anti-patterns',REPLACE('2015 SELECT Journal Editor s Choice Award! Most presentations on SQL performance assume that the query developer is highly experienced in SQL and Oracle and focus on tracing and other technique. Sadly, in today''s world, knowledge of SQL and Oracle are not highly valued, and many SQL performance problems are the result of inexperience, misguidance, "heard it/read it somewhere" and various source of mis-information. This presentation will address common "anti-patterns" in database design and SQL query writing that I''ve encountered over the years and how to fix them without tracing, changing init.ora parameters or techniques requiring DBA level privileges. It is focused on techniques that are typically available to developers.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Financial Close','Financial Close in the Cloud',NULL,NULL,NULL,'Mike Janik','New Flyer Industries Canada ULC','Edward Roske, interRel Consulting','A Real-World Implementation of FCCS: Lessons Learned and Mistakes You Do Not Want to Repeat',REPLACE('One month after Oracle Financial Consolidation and Close Cloud Service (FCCS) product was released, we found ourselves deep in the thick of implementing a solution and there was no roadmap to follow. To begin with, we quickly discovered that HFM and FCCS are as similar as two completely dissimilar things could be... as was implementing FCCS vs HFM. We then found out that while there were many prebuilt things that existed in FCCS that didn''t exist in HFM, things we felt surely must exist (specific forms, reports, and calculations) weren''t there at all. How did we work around what was missing? How did we take advantage of what was there? How can you learn from our journey of exploration (so you can be a lot smarter in your journey)? While there''s far more than an hour''s worth of lessons, we''ll make sure we cover the big ones before the session is over.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Financial Close','Financial Close in the Cloud',NULL,NULL,NULL,'Mike Janik','New Flyer Industries Canada ULC','Glenn Schwartzberg, interRel Consulting','Reconciliations Made Easy in the Cloud at New Flyer',REPLACE('The most significant time-consuming (and boring) step in closing your books is verifying that the data ties: does the total from the AP sub-ledger equal the Accounts Payable line in the GL, does the journal entry detail match the account balances, and does the General Ledger foot to what s in FCCS or HFM?  Oracle EPM''s solution to quick reconciliation of data? Account Reconciliation Cloud Services (which also has an on-premise version if you want to kick it old school). This technology will not only speed up your manual reconciliations by helping you find the discrepancies, in most cases, it will do it automatically.  Come learn how New Flyer reduced our close cycle (and got a large dose of our sanity back) with Oracle Account Reconciliation Cloud Service.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Financial Close','HFM',NULL,NULL,NULL,'Dennis Jensen','FLSmidth A/S',NULL,'Do you want an extra custom dimension with that ?',REPLACE('Why should you consider having more than 4 custom dimensions in your HFM application ?<<CHR(10)>>At FLSmidth we found, that we could solve some major reporting pains while also making the application more simple and intuitive<<CHR(10)>>The presentation will cover areas such as:<<CHR(10)>>&bull;  Which reporting dimensions we use<<CHR(10)>>&bull;  The problems with having multiple reporting dimensions on one custom dimension<<CHR(10)>>&bull;  Why it matters on which custom dimension you place your reporting dimensions, when you have more than 4 custom dimensions<<CHR(10)>>&bull;  The benefits of the DataSource dimension<<CHR(10)>>&bull;  Concerns about negative influence on performance<<CHR(10)>>&bull;  Be careful not to make data input from users to complex or cumbersome<<CHR(10)>>&bull;  Changing metadata and rules<<CHR(10)>>&bull;  How to use FDMEE to convert the historical data','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Financial Close','HFM',NULL,NULL,NULL,'Dennis Jensen','FLSmidth A/S',NULL,'Tools for rules',REPLACE('Tips&tricks for how to make your task as a HFM rule programmer just a little easier:<<CHR(10)>>&bull;  Create your own powerpack for Notepad++, adding formatting capabilities such as expand/collapse blocks of code, background colouring, etc.<<CHR(10)>>&bull;  How to measure time for running your rules calculations<<CHR(10)>>&bull;  How to use UD s and member lists to create custom lists for your rules programming, and make your rules maintenance more simple<<CHR(10)>>&bull;  Open dataunit   your best friend for limiting data processed by your rules code<<CHR(10)>>&bull;  Use variables !<<CHR(10)>>&bull;  Create on/off switches that can be updated in a dataform, to enable activation/deactivation of validations etc. without changing rules<<CHR(10)>>&bull;  Use WriteToFile for your debugging','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Data Integration','Cloud Integration',NULL,NULL,NULL,'Jason Jones','Applied OLAP, Inc.','Jon Harvey, eCapital Advisors','The PBCS REST API Demystified',REPLACE('Oracle''s Planning and Budgeting Cloud Service (PBCS) offers a REST API, but how does it work and what can it do? This presentation for administrators and developers will give an approachable overview of how the API works, what its capabilities are, and how it can be practically used in automation and data integration scenarios.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Real World',NULL,NULL,NULL,'Tyson Jouglet','SkillBuilders',NULL,'Event Driven Applications Using Custom JS Events',REPLACE('Have you ever wanted to have the same dynamic action fire for different events, if the user clicks a button, or if she presses enter? Out of the box it appears that APEX cannot handle this situation. There is a very simple solution using custom events and event emitters in JavaScript.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Financial Close','Financial Close in the Cloud',NULL,NULL,NULL,'Pritpal Kalsi','SC&H Group, LLC',NULL,'Hacking FCCS to Create a Custom Consolidation Engine',REPLACE('We ve all heard it 1,000 times before; FCCS is NOT HFM in the cloud. But can you hack it to make it HFM in the cloud? Don t worry Oracle, we are not hacking your software, but we will show you how to use out-of-the-box tools that are part of FCCS to make it your own unique consolidation engine. In this demonstration, you will learn tips and tricks that we have used with our FCCS clients to make applications more flexible, dynamic and customizable than you ever thought possible. We will also cover the latest and greatest functionality up to and including the June 2017 FCCS release.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Calculation',NULL,NULL,NULL,'Celvin Kattookaran','Intekgrate',NULL,'King/Queen of CDFs has arrived',REPLACE('The King or The queen of CDFs has arrived. This session talks about the latest CDF offering from Calc Manager which can be used to write CDFs from Calculation scripts itself.<<CHR(10)>>What if you want to execute a SQL procedure from Calc script? What if you want to run a select statement?<<CHR(10)>>All that and beyond is now possible with @CalcMgrGroovyString and @CalcMgrGroovyNumber functions. This session will include sample codes for all the topics covered above','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','SmartView',NULL,NULL,NULL,'Justin Kern','Vertical Edge','John Taylor, Vertical Edge Consulting Group','Ready...Aim...Fire...The low down on Smart View''s Features for Reporting',REPLACE('Are you good at hitting the refresh button on a template that someone else created, but you need to know how to build data retrievals using the Hyperion Smart View Office Add-In?  Are you aware of the all the alternatives for querying data and know which is best for each type of report?  This session will cover the different methods available for retrieving data against Essbase, Planning, and HFM data sources and the benefits/drawbacks of each one.  You will leave feeling confident and competent to start building all different types of data retrievals on your own.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','Financial Reporting',NULL,NULL,NULL,'Justin Kern','Vertical Edge','John Taylor, Vertical Edge Consulting Group','Web Reporting Studio will have your Saddles Blazin :  Learn the usage of this tool across several cloud products.',REPLACE('Web Reporting Studio is an online tool for developing and editing financial reports for your EPM applications in place of the traditional Financial Reporting Studio installed client.  It works across several of the cloud products and allows for everything to be done in a web browser without having to deal with all of the local computer installation problems.  Using Web Reporting Studio has a different look and feel than the traditional Financial Reporting Studio.  In this session we will cover the details on using Web Reporting Studio so you can get ahead with your reporting.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','ADF and MAF',NULL,NULL,NULL,'John King','King Training Resources',NULL,'Give MAF a REST: Using REST/JSON Services in MAF',REPLACE('Oracle s Mobile Application Framework (MAF) builds web applications quickly and easily that port to iOS and Android devices without target-specific customization. MAF applications may use data from Java POJO s, the local SQLite database, SOAP/XML Web Services, REST/XML Web Services, and REST/JSON Web Services. This presentation shows attendees how to create MAF applications based upon REST/JSON Web Services.  The combination of REST and JSON has become the standard mechanism for communicating with mobile applications; MAF developers attending this session will learn how to use them.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Dev',NULL,NULL,NULL,'John King','King Training Resources',NULL,'The THINGS are Here! Using Oracle IoT Cloud Service',REPLACE('First, the Internet connected us. Then we added computers and network connections to machines and things. Today many  things  (computers, sensors, devices, appliances, cars, phones, etc.) are connected to the Internet, to our applications, and to each other. The Internet of Things is exploding and you need to be prepared for it. In this session you will learn how the Internet of Things is changing our lives. Every day more use cases appear where we harness the tremendous flow of data coming from  edge  devices to enable better business decisions. Oracle s Internet Of Things Cloud Service is an instrumental part of this new world. This session will introduce you to IoT and Oracle s Internet Of Things Cloud Service.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Real World',NULL,NULL,NULL,'Moritz Klein','MT AG',NULL,'APEX Generator - The Clone Wars',REPLACE('Want to see how you can build 120 fully functional APEX pages in under five minutes? Just rebuild them if the data model changed in the same time? Then this session is for you! See the "APEX Generator" in action and learn how to use the Data Dictionary and the APEX Views to automate APEX page creation.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','Other BI and Reporting',NULL,NULL,NULL,'Michelle Kolbe','Red Pill Analytics',NULL,'Using R for Data Profiling',REPLACE('The benefits of knowing your data before embarking on a BI project are endless. Sure you can buy a tool to help with this. Or you could use R, an open source tool. This session will dig into methods for using R to connect to your data source to see visual and tabular analyses of your dataset. You''ll learn how to find missing data, outliers, and unexpected values. If you don t know R or you are wanting to learn more functions within R, you ll benefit from this session.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DevOps/Agile',NULL,NULL,NULL,'Peter Koletzke','Quovera',NULL,'I''ve Looked at Cloud from Both Sides Now: Developer Cloud Service or Not?',REPLACE('If, like this presenter, you are a developer or IT professional who has been wary of cloud computing since first hearing about it, your objections to it probably run along the lines of price, complexity, loss of control over your development environment, security, and just good old stubbornness to change. Alternatively or additionally, if you work in an Oracle-oriented shop, the tendency may be to rely on Oracle''s products, but your shop is waiting for Oracle''s cloud products to mature before jumping in (flying up).<<CHR(10)>><<CHR(10)>>Whatever your opinion about cloud computing in general, and Oracle''s competency in cloud products specifically, Oracle Developer Cloud Service is worthy of examination now. Oracle Developer Cloud Service is a Platform as a Service (PaaS) product that provides a complete development environment for creation of applications in any discipline (for example, APEX, ADF, JET, MAX, ABCS, or Forms).<<CHR(10)>><<CHR(10)>>On the "Up" side, this presentation explains this service and how you can use it as an out-of-the-box solution for the full life-cycle of an application, or for integrating some of your own components into the service. <<CHR(10)>><<CHR(10)>>On the "Down" side, the presentation discusses why you may not want to use this service, and, if you do decide to use it, what to avoid when configuring and using the product. <<CHR(10)>><<CHR(10)>>The session closes with an example of setting up Oracle Developer Cloud Service to supply a full application life cycle that includes version control, code reviews, build integration, issue tracking, and deployment phases. You may be pleasantly surprised at what you learn about this product.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Dev',NULL,NULL,NULL,'Peter Koletzke','Quovera',NULL,'Thick Database is Alive: Leveraging the Oracle Database SQL and PL/SQL to Simplify Any User Interface Application Development',REPLACE('Whether you develop applications for an Oracle database in APEX, ADF, MAF, JET, MAX, ABCS, or any other development framework or programming language, the development approach known as "thick database" can provide benefits in productivity, code reusability, and ease of application maintenance. This approach to development evolved from discussions in ODTUG channels over ten years ago.<<CHR(10)>><<CHR(10)>>The thick database approach consists of centralizing most application logic in the database, which greatly simplifies the user interface work. It also shields the application somewhat from UI technology changes, so if an application framework needs to be changed, the amount of code to rewrite is much less than with business logic in the application.<<CHR(10)>><<CHR(10)>>This presentation explains the benefits, principles of, and guidelines for using this approach. It discusses how business rules logic can be centralized and standardized so that application updates due to business changes are much easier. It also describes different levels at which you can use the thick database principles: extreme, modified, and conservative, and how to decide which level to use. It also explains how you would decide which business rules should be implemented in the user interface even if they are also written in the database. <<CHR(10)>><<CHR(10)>>The session also suggests a simple system you can create to track business rules as one part of thick database development as well as a starting point for creating test plans. The session then shows examples of the main SQL and PL/SQL code components you might use to implement thick database principles: table APIs, complex views with INSTEAD OF triggers, and business rules procedures.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Dev',NULL,NULL,NULL,'Toon Koppelaars','Oracle Server Technologies','Bryn Llewellyn, Oracle Corporation','A Real-World Comparison of the NoPlsql and Thick Database Paradigms   Part 2',REPLACE('This is a two-part session.<<CHR(10)>><<CHR(10)>>In our second session, we turn to the Thick Database paradigm, rehearse the reasons for its superiority, and explain that it implies more than just allowing database calls to invoke only PL/SQL subprograms. We formalize a layered code classification scheme which leads to optimal understandability and maintainability of both your PL/SQL and your SQL code -- which properties bring the maximum probability of correct behavior. We will convince participants that adopting the Thick Database Paradigm guarantees the avoidance of the awful problems brought by the NoPlsql paradigm and establishes the database tier as a reliable central service provider in the application landscape. We will debunk the myth that  moving business logic out of the data tier and into the middle tier  improves scalability.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','OBIEE',NULL,NULL,NULL,'Peter Koutroubis','ERP Analysts','Jai Gangwani, ERP Analysts','FIU-180 Day Rapid Path Implementation of OBIA 11.1.1.10 -HR Analytics On-A-Budget',REPLACE('Case Study: Florida International University (FIU) Utilizing Oracle Business Intelligence Applications (OBIA) Human Resource Analytics (HRA) 11.1.1.9.2; A 180 Rapid Path Implementation of OBIA-HR Analytics On-A-Budget','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','OBIEE',NULL,NULL,NULL,'Peter Koutroubis','ERP Analysts','Jai Gangwani, ERP Analysts','Transitioning from OBIEE On-Premise to BI Cloud Services',REPLACE('Transitioning from OBIEE on-premise to BI Cloud Services.<<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Business Content','EPM/BI Strategies',NULL,NULL,NULL,'Teresa Kress','Summit Materials','Tiffany Briseno, Summit Materials','If You Build It, They Will Come: Transforming Our Close Process with Dashboard Reporting',REPLACE('Have you always dreamed of a dashboard reporting tool that had the slickest charts, graphs and trend lines to visualize your company s data?  In your dream, was your executive team (yes even your CFO and CEO) using this tool on their tablets or mobile devices with ease, drilling and clicking through regions and business units without bugging you for answers?   Were your analysts using this tool to input commentary explaining deviations, not in Excel but directly in this web-based tool?  In this dream, were you hailed as a hero with confetti reigning down on you for actually making mobile dashboard reporting work at your company?   Does this sound too good to be true?  Come listen to how a couple accountants made this happen at Summit Materials in less than a few months  time.  No, really.   Don t believe us come listen to how we mobile-enabled our HFM and Essbase data with CXO-Cockpit.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Planning','Other Planning',NULL,NULL,NULL,'Prasad Kulkarni','Oracle Corporation',NULL,'What''s New and Coming in Planning',REPLACE('In this session you will hear Oracle''s strategy for on-premise offering in the Planning domain.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Other Essbase',NULL,NULL,NULL,'Cameron Lackpour','ARC EPM','Tim German, Qubix','Essbase Cloud is Here.  Now What?',REPLACE('Essbase Cloud is finally among us.  But what does that really mean?  How does it fit into our existing EPM environments?  What does Essbase Cloud actually do that s better than before?  What paths are not taken?  In short, does Essbase Cloud live up to its promise?  Join Tim German and Cameron Lackpour as they explore and explain Essbase Cloud s :  architecture, functionality, use cases, cost, and performance.  This comprehensive review of the essence of Essbase in the cloud gives you the answers and direction you need to go forward with Essbase now and in the future.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','Financial Reporting',NULL,NULL,NULL,'Alan Lee','Oracle',NULL,'Build Once, Run Anywhere with Oracle Analytics Cloud',REPLACE('summary to come','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','Other BI and Reporting',NULL,NULL,NULL,'Alan Lee','Oracle',NULL,'Oracle Analytics Cloud - A Comprehensive Overview',REPLACE('Summary to come','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Real World',NULL,NULL,NULL,'Oliver Lemm','MT AG',NULL,'Mastering Universal Theme with Corporate Design from Union Investment',REPLACE('You want to migrate to APEX 5 and the Universal Theme but, until today, you''ve only seen a few trivial presentations? Furthermore, you want to integrate your''s or your customer''s Corporate Design? In this presentation, you will get a bunch of knowledge which will help you to migrate to the Universal Theme. The APEX Application FondsProfiler was created in 2011 with APEX 4.1 and Theme 22.<<CHR(10)>>The first step to the Universal Theme is to choose which old templates should be mapped to which templates from the Universal Theme. Then you have to make the choice between keeping the subscription to the Universal Theme and trying to make the design changes only with CSS, jQuery and some copied templates. Or you release the subscription and making changes easier now, but resulting in problems later when going to Universal Theme 1.x.<<CHR(10)>>Another problem in many migrated applications is the big space between your items and the grid layout from the Universal Theme. You will get solutions how to arrange your items near to each other and still using Universal Theme templates.<<CHR(10)>>Mastering design changes with theme roller, be aware of problems like !, important in your and theme roller''s CSS. Having customized Tooltips, locking mechanism, or want to color your input fields based on the user''s right -  these questions will be answered in this presentation.<<CHR(10)>>This presentation will be far more detailed than every other migration presentation you''ve heard before.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Real World',NULL,NULL,NULL,'Oliver Lemm','MT AG',NULL,'Uncover the Truth',REPLACE('Got an old APEX Application to migrate or extend? Struggling by not knowing how complex the application is and which pages are full of customized code?<<CHR(10)>>Furthermore, you might not know how the pages are related? Join this presentation to get fast answers for your most important questions. It will be presented how to identify which templates have been changed, how much CSS, JavaScript Code, and PL/SQL Code is hidden in your application pages. Even a tree view for the page navigation can be created automatically to understand how your pages are related. <<CHR(10)>>With this information you can understand the application very fast and it s much easier to make an effort analysis bringing new features to your application.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Other Essbase',NULL,NULL,NULL,'Steve Liebermensch','Mensch Consulting',NULL,'Analyst Seeks Analysis Tool: An Introduction',REPLACE('An introduction to Essbase, you could consider this an Essbase 101 session.  In this presentation attendees will learn about the why''s and how''s of Essbase including very basic design concepts, navigating a couple of the common user interfaces, as well as some the basics for query and reporting.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Planning','Other Planning',NULL,NULL,NULL,'Steve Light','TransUnion','Robert Kocur, TransUnion','Taking Your Hyperion Culture from Good to Great!',REPLACE('Financial planning for a billion dollar companies like TransUnion can feel like a daunting task, but Hyperion provides businesses the right tools to be successful.  Hyperion can make it significantly easier to be good at planning, but you really need the right team and culture to be great!  Fortunately for TransUnion, the new Global Hyperion Solutions Team and the Hyperion Community of Interest are on the job.  Hyperion, as a tool, has been part of TransUnion since 2010 and has proven to be very successful with over 200 Finance and Accounting associates utilizing 19 applications across a truly global organization. The environment has grown to include Hyperion Planning (BSO & ASO), Essbase (BSO & ASO), Workforce Planning, Capex, PFP, Hyperion Strategic Finance, FDM, and Financial Reports. The applications quickly evolved from a few departmental tools to a set of strategic world-wide applications that support all aspects of the business in the US, Canada, Latin America, Africa, India, and Asia.  For years, the system was maintained via some heroic individual efforts and a rotating stable of consultants, but in 2016 TransUnion decided to create a dedicated Hyperion team and the Hyperion CoI.  This support is a demonstration of the dedication TransUnion has to making sure our end users on the finance team have the best experience possible.  In just a few short months, we ve moved from good to great, and we re just getting started!','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','Other Database',NULL,NULL,NULL,'Debra Lilley','Certus Solutions',NULL,'How to Get the Most out of User Groups',REPLACE('Summary to come','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Other Essbase',NULL,NULL,NULL,'Philippe Lions','Oracle',NULL,'Oracle Analytics - Advanced Data Visualization with Essbase',REPLACE('Summary to come','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','OBIEE',NULL,NULL,NULL,'Lily Liu','interRel Consulting',NULL,'PBCS & BICS Better Together: Why, When & How',REPLACE('Oracle has powerful planning and forecasting solutions in the Cloud with PBCS along with easy to use visualizations and dashboarding in the Cloud with BICS. While PBCS has its own dashboarding capabilities, there is still a compelling use case for combining PBCS and BICS into a best practice solution. Join us for this session where we will share with you the  Why  on use cases for PBCS and BICS, the  When  of when it makes sense to combine and what stage of the implementation process, and the  How  of how to actually integrate data between the two solutions. We ll demo examples of the integrations start to finish and show you the power of BICS on top of PBCS and other data sets from an end user perspective. You ll leave this session with the tools in your tool belt to implement PBCS & BICS together!','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Dev',NULL,NULL,NULL,'Bryn Llewellyn','Oracle Corporation','Toon Koppelaars, Oracle Corp','A Real-World Comparison of the NoPlsql and Thick Database Paradigms   Part 1',REPLACE('The NoPlsql paradigm starts with an object oriented domain model in the middle tier. This leads naturally to treating the database as a bag of tables, so that primitive SQL statements express its API. The Thick Database paradigm starts with the design of the relational model. This leads naturally to allowing client-side code only to call PL/SQL subprograms, so that all SQL is done from PL/SQL. These two paradigms are mutually incompatible.<<CHR(10)>><<CHR(10)>>This is a two-part session.<<CHR(10)>><<CHR(10)>>In our first session, we show, based on real-world use cases, how the NoPlsql paradigm brings problems with correctness, security, and performance, and we note that projects that adopt the NoPlsql paradigm use most of their resources on developing plumbing code rather than code that implements actual business functionality. These problems are just the tip of the iceberg and we explain how the NoPlsql paradigm also brings maintenance nightmares.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DBA',NULL,NULL,NULL,'Robert Lockard','Oraclewizard',NULL,'A Holistic Approach to Database Security',REPLACE('For years we have been locking down the software to protect information. This presentation puts the focus where it belongs: identifying, protecting, and selecting the correct tools to protect your data. <<CHR(10)>>Starting with a brief history of security breaches and the impact to both companies and consumers, the presenter will move through a methodology of identifying sensitive information, creating a risk matrix, and which tools are available to mitigate information leaks.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Infrastructure','Cloud and Hybrid Infrastructure',NULL,NULL,NULL,'Jiten Majithia','Infratects Consulting LTD','Athanasios Antzoulatos, Compass Group PLC','Rehosting Your On-Premises Hyperion EPM Solution on Amazon Web Services: The Compass Group Story',REPLACE('Compass Group PLC made a strategic decision to host its internal operational systems on Amazon Web Services (AWS). Through this strategic IT decision, Compass Group PLC partnered with Infratects Consulting to upgrade their HFM Financial Reporting platform to v11.1.2.4 and re-host from an internal, on-premises solution to Amazon Web Services, delivering a new/improved Finance System serving a user-base across 40 countries.<<CHR(10)>><<CHR(10)>>What are some of the conversation and challenges you are facing when thinking of moving your EPM platform to the Cloud? Attend this presentation to hear about some of the key decisions, risks, and business/technology challenges we faced on this journey.<<CHR(10)>><<CHR(10)>>Agenda:<<CHR(10)>>&bull;  Basics about on-premises vs. Cloud Implementations for EPM<<CHR(10)>>&bull;  History of Compass Group PLC s decision to move to the Cloud<<CHR(10)>>&bull;  Key business & technology drivers for moving their EPM platforms to Amazon Web Services.<<CHR(10)>>&bull;  Architecture delivered for the solution<<CHR(10)>>&bull;  Challenges faced and lessons learned during Implementation','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Infrastructure','Installs and Upgrades',NULL,NULL,NULL,'Joe Malewicki','iArch Solutions',NULL,'The EPM Clouds are Rolling in Fast!  Is It Really Worth Upgrading My On-Prem System Now?',REPLACE('So it s here.  The storm has been brewing and it looks like this time, we might actually see some weather.  Yes folks, Oracle is full tilt on the Cloud!  Better late than never right?  Well   maybe yes, but don t put up those hurricane shutters just yet.<<CHR(10)>><<CHR(10)>>The reality is yes; everything is headed to the cloud.  At some point we re all going to be wearing our rain jackets and have our umbrellas open as we  sing in the rain  of Cloud based EPM applications.  However, this session isn t about  tomorrow.   It s about TODAY. <<CHR(10)>><<CHR(10)>>Today you have a fully baked, production running EPM/Hyperion system.  You ve got Essbase cubes crunching data, Financial Management Consolidations firing off daily, Planning web forms being updated every week and finally tons of users with a local version of Excel 2010 on Windows 7 complaining daily  Smart View is too slow!   You ve got IT and Risk Management stating Microsoft has cut off the version of SQL Server and Windows 4 years ago yet Hyperion is still lingering along on these unsupported platforms. Why?  Because you can t run your business WITHOUT Hyperion.<<CHR(10)>><<CHR(10)>>In this session we ll help you address and develop a plan with minimal to NO downtime to get your  on-prem  Hyperion installation up to the latest and greatest available from Oracle.  We ll help you decide what makes the most sense for an upgrade path.  On-prem hardware, virtualizing, hosted environments, or shared resources.  Discussions on 3rd party hosting providers and yes, discussions on Oracle s Cloud versions of their EPM software stack and how all relates to an upgrade.<<CHR(10)>><<CHR(10)>>We ll take the mystery out of the upgrade process for the software itself.  Discuss the version paths and how to ensure you can get the latest platform support that your organization is comfortable with while still maintaining full support model from Oracle.<<CHR(10)>><<CHR(10)>>You ll see a LIVE demonstration of  BEFORE  and  AFTER Upgrade  real world EPM application performance and system functionality.<<CHR(10)>><<CHR(10)>>Finally we will discuss just how inexpensive an on-prem upgrade can actually be.  The cost and time savings alone should make you head back to the office and start planning the project.<<CHR(10)>><<CHR(10)>>So please join us for this educational and informative session and let s get you up to where you should be today!<<CHR(10)>><<CHR(10)>>And remember   someone s  cloud  is just someone else s  computer. ','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Essbase-related technologies',NULL,NULL,NULL,'John Maloney','TopDown Consulting','Paul Hoch, TopDown Consulting','How to Get the Most Out of Essbase in the Cloud',REPLACE('Essbase in the Cloud has been eagerly anticipated and now that it is finally here we will explore how Essbase in the Cloud can replace, enhance or serve the same role as your current on-premise Essbase environment. This session is a thorough look at Essbase in the Cloud, including a look at the differences between on-premise Essbase and the Cloud offering, what you re getting and what you re giving up, best practices for working with Essbase in the Cloud, particularly if you are running a Hybrid EPM Solution, plus tips and tricks for how to make the most of Essbase in the Cloud. This session will also include a review of features like calculations, currency conversions, sandboxes, and other key things you need to know to get started. It will also include real-world examples. You will leave with a solid understanding on how to work with Essbase in the Cloud so that you can start taking advantage of all it has to offer.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','Other BI and Reporting',NULL,NULL,NULL,'Al Marciante','Oracle Corporation',NULL,'EPRCS',REPLACE('summary to come','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','Other BI and Reporting',NULL,NULL,NULL,'Enrique Marron','GE','Abed Bokaie, GE','Wrangle & Lasso EPM Data Using Java API',REPLACE('Oracle Hyperion EPM modules access data in many different ways, as well as being co-dependent. Some of these dependencies are a Windows operating system, Microsoft Office, a web browser, and various desktop clients. But what we will share is a solution that removes us from that equation completely. <<CHR(10)>>In this presentation, we will take everyone off of the ranch to share a solution that unlocks all users from today s boundaries of EPM data retrieval and ad hoc analysis.<<CHR(10)>>This unique solution will allow all users alike to still remain true to the core functionality of their EPM data, tools, and utilities that they most likely use today to perform retrievals: a grid-like presentation-style (i.e. row and column format User Interface - UI.) This presentation will take a glimpse into the developed code that leverages the commonly exposed EPM Java APIs.<<CHR(10)>>The benefits users could receive from this work are:<<CHR(10)>>&bull;  Essbase Java API<<CHR(10)>>&bull;  Operating System Agnostic exposure to EPM Data<<CHR(10)>>&bull;  Easy ad hoc analytic data retrieval ability<<CHR(10)>>&bull;  User Interface & User Experience in a desired and familiar format<<CHR(10)>>&bull;  Common core ad hoc options<<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Optimization',NULL,NULL,NULL,'Brian Marshall','US-Analytics',NULL,'IT Made Me Virtualize Essbase and Performance Sucks:  Making Essbase Fast In Any Environment',REPLACE('We can t all have an Exalytics box for our Essbase environment.  In fact, if you haven t made it to the Cloud, then you are most likely already on a virtualized environment or being "encouraged  heavily to go to a virtualized environment.  This presentation will focus on making sure that your transition is as smooth as possible.  We''ll discuss specific settings in the virtual environment, the operating system, and Essbase to get the most out of your server. We''ll also compare specific benchmarks around different hardware configurations related to CPU, Memory, and Storage. Attendees will receive the new EssBench application for standardized benchmarks to see how your system stacks up.  This application is deployable to any Planning server to test various aspects of your server s performance to identify areas for improvement.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Data Visualization & Advanced Analytics','Oracle Data Visualization',NULL,NULL,NULL,'Kevin McGinley','Red Pill Analytics','Tim German, Qubix','Oracle Data Visualization for the Finance Analyst',REPLACE('Many analysts within Finance are used to manipulating spreadsheets and waiting for enhancements to Essbase cubes to produce reports that need to be shared with their management or peers. This session will demonstrate how all analysts within Finance can get immediate value from Oracle Data Visualization (DV) and decrease their reliance on overly complex spreadsheets. From its ability to connect to many different kinds of data sources, wrangle multiple data sources into a usable format, and visualize insights that would be otherwise hard to see in a table, Oracle DV provides analysts an extra layer of functionality they can easily learn and use without IT intervention.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Planning','Other Planning',NULL,NULL,NULL,'Ryan Meester','Edgewater Ranzal','Lezlee Herdina, POET','True Power of Oracle s Enterprise Planning Suite Unleashed at POET',REPLACE('To quote Lezlee Herdina, Director of FP&A at POET,  POET s mission is to live in a world with natural balance. Where we no longer take from the earth, but rather use its enormous ability to regenerate. We will use this tool (Hyperion) to model strategic opportunities to achieve that goal. <<CHR(10)>><<CHR(10)>>POET, a leading biofuel company specializing in the production of ethanol and ethanol co-products, needed a platform to support its performance management initiatives and ultimately the company mission, which required generating fully integrated Income Statement, Balance Sheet, and Cash Flow projections over a 5 year planning horizon.  It needed a system that could provide short-term detailed operational budgeting capabilities for various aspects of the business (i.e. SG&A, Capital Planning, Project Planning) while also delivering a flexible solution to allow for higher level long-range planning.  In search of these overall process improvements and efficiencies related to the budgeting and long-range planning processes, POET turned to Oracle and Ranzal to deliver a best in-class solution using Oracle s suite of EPM applications.  During this session Lezlee Herdina and Ryan Meester, Director at Edgewater Ranzal, will guide the audience through the process in which POET and Ranzal worked together,  using the  Right tool for the right job  mantra, to unleash the true power of Oracle s Enterprise Planning suite including Oracle Hyperion Strategic Finance, Hyperion Planning (Including Workforce, Capital and Project Financial Planning!), Essbase, and Financial Data Management Enterprise Edition.  <<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','Other BI and Reporting',NULL,NULL,NULL,'Matt Milella','Oracle Corporation',NULL,'A Story about Data: Anything, everywhere with everyone',REPLACE('Summary to come','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','Testing',NULL,NULL,NULL,'Cary Millsap','Cintra Software and Services',NULL,'Thinking Clearly about Testing Performance',REPLACE('Testing for functional correctness is generally a matter of specifying the right output for a given input and then using a tool that check whether your code produced the output you specified. Testing performance, though, is a lot harder, even conceptually. You can use a tool to check whether a given function "runs in D seconds or less," but there''s more to it than that, because realistic data volumes and loads matter so much. But you can prevent a lot of post-production performance problems without having to spend a gazillion dollars on "perfect" performance testing. In this session I''ll help you learn how.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','OBIEE',NULL,NULL,NULL,'Robin Moffatt','Rittman Mead',NULL,'OBIEE System Administrator''s Troubleshooting Toolkit - Deep Dive',REPLACE('As a DBA or sysadmin responsible for OBIEE how do you really dig into the guts of OBIEE, look at intra-component communication between the system components and examine the apparently un-examinable? What do you do when you need to trace activity beyond what is in the log files? How do you work with log files in order to give precise but low level information? What information can be gleaned, by hook or by crook, from OBIEE?<<CHR(10)>><<CHR(10)>>OBIEE provides a set of systems management and diagnostic tools, but these only take you so far. Join me in this presentation to dive deeper with OBIEE. We will take a look at a bag of tricks including undocumented configuration options, flame graphs, system call tracing, discovering undocumented REST APIs, and more! This is not *just* a geek-out - this is real life examples of where client OBIEE projects have required that next level of diagnostic techniques and tools. Don your beanie hat and beard as we go deep!<<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Data Warehousing & Big Data','Other',NULL,NULL,NULL,'Robin Moffatt','Rittman Mead',NULL,'Analyzing the Panama Papers with Oracle Big Data Spatial and Graph',REPLACE('Oracle Big Data Spatial and Graph enables the analysis of data sets beyond that of standard relational analytics commonly used. Through Graph technology relationships can be identified that may not otherwise have been. This has practical uses including in product recommendations, social network analysis, and fraud detection.<<CHR(10)>><<CHR(10)>>In this presentation we will see a practical demonstration of Oracle Big Data Spatial and Graph to load and analyse the "Panama Papers" data set. Graph algorithms will be utilized to identify key actors and organizations within the data, and patterns of relationships shown. This practical example of using the tool will give attendees a clear idea of the functionality of the tool and how it could be used within their own organization.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Calculation',NULL,NULL,NULL,'Ron Moore','TopDown Consulting','Ludovic DePaz, TopDown Consulting','Extreme Essbase Calculations: New Frontiers in What-if, Goal-seeking and Sensitivity Analysis',REPLACE('Doing what-if isn t new.  As long as I can remember everyone talked about it and the goal-seeking functionality using LOOP has been around for decades.  But do most of our calculations use causal drivers or are they  type it in and agg it up  type databases? And how much "what-if-ing" can you really do if the database takes an hour to aggregate? <<CHR(10)>><<CHR(10)>>Today more and more companies are using driver-based designs and recent improvements such as Hybrid Aggregation, new calculation functions, and bigger hardware mean that there are new possibilities. Profit opportunities don t usually follow simple linear patterns. Well-designed driver-based models capture complex patterns and help identify risks and opportunities that would otherwise be missed.  Goal-seeking can significantly reduce the time it takes to set and distribute targets.  Sensitivity analysis can help set priorities by identifying the most important drivers.  It can also help compare a range of options to identify sweet spots. <<CHR(10)>><<CHR(10)>>First we will examine the business logic behind some useful what-if calculations that help uncover financial dynamics that make a difference in business results.  Then we will examine the outline and business rule considerations and options.  Then we will dig into the code.    <<CHR(10)>>We will show examples of outlines and business rule code for:<<CHR(10)>>&bull;  Pushing down top-side budget adjustments  <<CHR(10)>>&bull;  Driver based what-if calculations<<CHR(10)>>&bull;  Goal-seeking for target setting<<CHR(10)>>&bull;  Prioritization and range comparison with sensitivity analysis<<CHR(10)>><<CHR(10)>>Last we will show some examples of using these techniques in real-world applications.<<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Planning','Optimization',NULL,NULL,NULL,'Ron Moore','TopDown Consulting','Brian Brockway, Suez','Case Study: How Suez Slashed Cycle Times and Improved Service Levels with Hybrid Aggregation',REPLACE('Suez owns and operates 16 water and waste utilities and operates 90 municipal water and waste water systems.  They had a very large Planning cube and aggregations could take three hours or more. They had to choose carefully which aggregations they did and when.  Administration was arduous. This put severe limits on what Suez could do to improve service levels to users.<<CHR(10)>><<CHR(10)>>Suez partnered with TopDown Consulting to optimize the application. TopDown performed a series of tests on more than a dozen optimization techniques. The results provided two good options. FixParralel could reduce aggregation times to about 20 minutes.  And even though Suez was on 11.1.2.3.500, the application appeared to be a good candidate for Hybrid Aggregation which would eliminate the aggregation.  <<CHR(10)>><<CHR(10)>>In this session Brian Brockway, Manager - IT Applications and Support at Suez and Ron Moore, Solution Architect at TopDown Consulting will describe:<<CHR(10)>>&bull;  the tests performed to identify the best optimization options <<CHR(10)>>&bull;  the steps to determine if the cube was a candidate for Hybrid Aggregation<<CHR(10)>>&bull;  the trade-offs between FixParallel and Hybrid Aggregation and how Suez decided which option to pursue<<CHR(10)>>&bull;  the step by step process (including code samples) of converting the cube to hybrid, including  cross-dimensional operators, time balances, MDX WITH clauses, and other challenges<<CHR(10)>>&bull;  how Suez addressed the effects of some of Hybrid s disadvantages <<CHR(10)>><<CHR(10)>>Finally, we will describe how Hybrid transformed service levels for users and list the benefits of the conversion.   <<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Integration',NULL,NULL,NULL,'Vincent Morneau','Insum',NULL,'Creating an APEX Theme for Non-Designers',REPLACE('The fastest way to produce a beautiful application is by using APEX 5 s Universal Theme. The fastest way to customize that look and feel is by using Theme Roller. In a matter of hours you can have a unique design using built-in options only. But sometimes that simply won t fit your client needs. <<CHR(10)>><<CHR(10)>>Not everyone can be a designer, write CSS, or is able to recognize a good design. That being said, I think every APEX developer has the skills to look at any online design and integrate it into APEX. <<CHR(10)>><<CHR(10)>>Integrating a theme is mostly about understanding how to properly copy/paste code in the designated sections of APEX and replacing the hard-coded content with APEX substitution strings. <<CHR(10)>><<CHR(10)>>This session will explain how you can use bits and pieces of an online design to create your own beautiful application. You should be able to ask your client to choose his/her preferred design through an online store and make your application look exactly like it.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Detail Plunge',NULL,NULL,NULL,'Vincent Morneau','Insum',NULL,'Modern JavaScript in APEX: What to tTake and What to Leave',REPLACE('By now, JavaScript is inevitable for all APEX developers. <<CHR(10)>><<CHR(10)>>The rising popularity of JavaScript didn t make everyone happy. There has rarely been a language that changes so much over time, making it hard to keep up with all the new tools and frameworks that emerge every now and then. This causes most APEX developers to stick to basic JavaScript functionalities.<<CHR(10)>><<CHR(10)>>This session will appeal to intermediate and advanced developers who wants to learn more about modern JavaScript but don t know where to start.<<CHR(10)>><<CHR(10)>>Among a lot of extraneous tools and frameworks, there has been a few highly adopted standards. We will be exploring the usefulness of MVC Frameworks such as Angular and it s alternatives like React. We will see how to write cleaner code with namespacing and promises. We will talk about using upcoming JavaScript features with ES6 and Babel and we will look into modularizing code with Browserify.<<CHR(10)>><<CHR(10)>>This session is a go-around what s available in JavaScript today and knowing what s useful (or not) as an APEX developer.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','ADF and MAF',NULL,NULL,NULL,'Jamie Morrison','Peak Indicators Ltd.',NULL,'Introduction to ADF: Building an Application in 60 Minutes.',REPLACE('Discover how to create a basic browser based application using the latest version of JDeveloper 12c and Application Development Framework (ADF). <<CHR(10)>> <<CHR(10)>>In the session we will start with a blank canvas from which we will build up a working HR application using core technologies and functionality, we will compile it, then deploy it to our Weblogic server where we can see it in action. During the session we will dip in to aspects such as creating data capture forms, skinning, and creating custom menu options.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Business Content','Budgeting and Planning Processes',NULL,NULL,NULL,'Bill Mowle','Children''s Hospital Colorado','Tracy McMullen, interRel Consulting','A Case Study: Implementing EPBCS at Children s Health Colorado',REPLACE('Join us for this informative session where we will review our implementation of Enterprise Planning and Budgeting Cloud Service (EPBCS). Learn how we implemented the pre-built Financials framework of EPBCS in just weeks, implementing driver, and trend-based forecasting for the entire hospital along with initiative planning. We ll demo our solution, show you what we used out of the box and what we customized, and share lessons learned when implementing EPBCS. We ll also share how we integrated EPBCS Cloud data with on-premise Essbase and OBIEE. Don t miss the success story of the first ever EPBCS implementation!','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DBA',NULL,NULL,NULL,'Francisco Munoz Alvarez','Pythian',NULL,'Logging or Nologging: That is the question!',REPLACE('The main question about NOLOGGING I hear all the time is: does creating a table with the NOLOGGING option means there is  no generation of redo ever," or just that the initial creation operation has no redo generation, but that DML down the road generates redo?  How and when can the NOLOGGING option be employed?<<CHR(10)>>Redo generation is a vital part of the Oracle recovery mechanism. Without it, an instance will not recover when it crashes and will not start in a consistent state. Excessive redo generation is the result of excessive work on the database.  This presentation covers the subject of reducing redo generation using LOGGING and NOLOGGING options, the differences between them, how it happens, how to reduce it, and when to use. Also, you will find examples and tips regarding each one of them.<<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DBA',NULL,NULL,NULL,'Francisco Munoz Alvarez','Pythian',NULL,'Tips and Best Practices for DBAs',REPLACE('A vibrant session with  Real Tips  for real world daily database problems a DBA could find. Here you will learn how to improve your productivity, how to solve some real DBA problems, and also learn several tips to help you to become a successful DBA. This session is based on some of the most frequent questions I m asked on my blog and during my presentations. (Version 3 of this presentation.)<<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Business Content','EPM/BI Strategies',NULL,NULL,NULL,'Michael Nader','Huron Consulting Group',NULL,'Finding the Forest Among the Trees - Designing and Implementing an Analytic System',REPLACE('Business Intelligence is about three things   analysis, access, and visibility. Increasingly, business analysts are demanding insight into ever-more detailed data. A well designed BI system should not just tell you what happened, but why it happened.  It should help you find the needle in the haystack.<<CHR(10)>><<CHR(10)>>This session presents both a case study and tips and tricks around implementing an analytic system and strategy. During the session participants will see live demonstrations of prototype environment as well as discuss design principles and implementation processes.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Design',NULL,NULL,NULL,'Michael Nader','Huron Consulting Group',NULL,'Solving the Labyrinth   Advanced Essbase Reporting with OBIEE',REPLACE('The Oracle Business Intelligence Foundation Suite contains two world-class modeling and reporting engines   Essbase and the Oracle BI Server. Integrating the two engines has, over the years, been complex. Often, the Essbase user community feels like they are losing capability. The reality is very much to the contrary; OBIEE provides opportunities for greater analysis. <<CHR(10)>><<CHR(10)>>This session provides two client case studies and tips and tricks for reporting on Essbase with Oracle Business Intelligence. This session contains live demonstrations of RPD modeling techniques for working with Essbase models, reporting tricks for dynamic filtering of Essbase reports, and leveraging advanced OBIEE capabilities for asymmetric reporting. In addition, the session provides recommendations for Essbase design to support the OBIEE reporting environment.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Infrastructure','Cloud and Hybrid Infrastructure',NULL,NULL,NULL,'Noah Neal','Key Performance Ideas, Inc.','Steven Wang, Key Performance Ideas, Inc.','Enhance Your Cloud Application with EPM Automate and REST APIs',REPLACE('Interested in reducing the time spent in your data loading processes? The EPM Automate utility and REST APIs can help you do just that and much more within the context of Oracle Cloud! Learn how these tools work and can be used for automating processes to save time in day-to-day business activities. These processes include data and metadata import and export, business rule launches, application backup and restore, retrieval of data management process detail logs, and much more. Also learn how EPM Automate and REST APIs can be integrated with scripts to perform a number of different tasks outside of Planning. We ll be discussing multiple sub-topics to help you get started and optimize automation processes, including:<<CHR(10)>>*EPM Automate vs REST API highlights<<CHR(10)>>*Scripting and syntax<<CHR(10)>>*Email notifications<<CHR(10)>>*Logging & Error Handling<<CHR(10)>>*Nuances<<CHR(10)>>*Maintenance Minimization<<CHR(10)>>*More!<<CHR(10)>>Find out more about how these powerful tools can allow your business to save time and enhance processes!<<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Calculation',NULL,NULL,NULL,'Martin Neuliep','General Electric Company',NULL,'Eliminating the Eliminations Problem in Essbase',REPLACE('For as long as there has been Essbase, people building financial applications have wanted to perform intercompany elimination calculations. Unlike HFM, Essbase up to now has not had this capability built in. So what to do, especially if eliminations are a key part of your reporting or planning requirements? Various approaches have been taken over the years and interestingly, there may be no one ideal solution even today.<<CHR(10)>>This session will compare four techniques for calculating eliminations: three purely within Essbase and a fourth using an adjunct relational database. We ll examine each according to these criteria, so you can choose an approach best suited to your needs:<<CHR(10)>>-  Ease of implementation<<CHR(10)>>-  Amount of ongoing maintenance required<<CHR(10)>>-  Flexibility<<CHR(10)>>-  Performance<<CHR(10)>>Code samples will be provided.<<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Data Visualization & Advanced Analytics','R and Oracle Data Mining',NULL,NULL,NULL,'Cuong Nguyen Tien','Mindstream Analytics',NULL,'Using Oracle R and OBIEE to Help Doctors Predict Areas with the Most Severe Health Problems',REPLACE('In every field we fight scarcity and shortage. In our session we will talk about the shortage of doctors and healthcare providers. What can we do to help healthcare organizations pick efficiently the areas with specific health problems and invest their efforts there?','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Detail Plunge',NULL,NULL,NULL,'Anton Nielsen','C2 Consulting, Inc.','Richard Soule, C2 Consulting, Inc.','APEX and the Thick Database Paradigm',REPLACE('The "thick database" concept relies on encapsulating business logic into a pl/sql layer and isolating the presentation layer by providing access only to the pl/sql layer. Thick database benefits include improved adherence to business rules, enhanced security, and improved performance. This approach is often discussed in relationship to Java, Pearl and other mid-tier centric development tools. APEX applications reside in the database, but they benefit from the thick database paradigm as well. This presentation will provide best practices and real-world considerations for thick database implementation within the APEX development realm.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DBA',NULL,NULL,NULL,'Rich Niemiec','Rolta',NULL,'Creating Your First Database to Access with Oracle''s DBaaS (DataBase as a Service)',REPLACE('This presentation will show the steps to create a Database in the Oracle Cloud using Oracle''s Database Cloud Service or DBaaS (DataBase as a Service).  It will give the brief steps as well as showing how to use the free test service.  We''ll also see different methods for testing in the cloud as well as the different uses for the Cloud initially and eventually.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Dev',NULL,NULL,NULL,'Rich Niemiec','Rolta',NULL,'The Best 12c R1 & R2 Query Tuning New Features',REPLACE('This presentation will look at which 12c new features should be investigated for query tuning.  Most of the features that will be covered will be related to the developer & DBA.  There will be simple examples to show the basic functionality of the new features: <<CHR(10)>><<CHR(10)>>- Using Invisible Columns<<CHR(10)>>- Multiple Indexes on the same Column<<CHR(10)>>- Adaptive Execution Plans<<CHR(10)>>- Runaway Query Management <<CHR(10)>>- Online Move Partition <<CHR(10)>>- Partial Indexes for Partitioned Table<<CHR(10)>>- Enhanced DDL Online<<CHR(10)>>- Other 12c Query Tuning New Features<<CHR(10)>>- Using Oracle In-Memory Database<<CHR(10)>><<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Design',NULL,NULL,NULL,'Peter Nitschke','Mpower Solutions','Cameron Lackpour, ARC EPM','Break the Shackles of Planning with Hybrid Essbase',REPLACE('Planning is Essbase, Essbase is Planning.  This powerhouse multi-dimension database enables Planning but then shackles it with BSO s long aggregation time and ASO s poor procedural calculations.  Hybrid Essbase breaks these architectural constraints by combining the calculation power of BSO with the aggregation performance of ASO and as a result fundamentally transforms how we design Planning applications.<<CHR(10)>><<CHR(10)>>Join Peter Nitschke and Cameron Lackpour as they demonstrate the value of Hybrid Essbase through its impact on real world Planning design.  You ll see multiple Plan Type applications collapsed into one, Plan Types literally small enough to fit on a USB stick, real world performance benefits, and calculation techniques that take best advantage of Hybrid while working around its current limitations.  The best use case of Hybrid Essbase is Planning and if you re a Planning practitioner you should be using Hybrid Essbase.  To do that, you need to attend this session and bring our real world Hybrid Essbase experience to your application today.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Integration',NULL,NULL,NULL,'Matt Nolan','FOEX GmbH',NULL,'Unlocking the power of the APEX plugin architecture',REPLACE('In this session you will get an in depth look into the APEX plugin architecture using a real world example where performance is critical, and the techniques used to optimize performance. <<CHR(10)>><<CHR(10)>>We will explore the best practices when in comes to designing plugins, event usage, increasing code centralization, and decreasing maintenance whilst plugging the functionality gaps in your APEX applications.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Real World',NULL,NULL,NULL,'Alex Nuijten','allAPEX',NULL,'Life after Forms: The Move to APEX',REPLACE('Companies struggle with the question: Should we move to APEX when the time has come to let go of Oracle Forms?<<CHR(10)>>This session will tell the story of a migration project where the Oracle Forms application needed to be replaced with an APEX application. What could we have done better? What are the lessons learned? What was the best choice that we made during this project? Not from the books, but from experience.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Dev',NULL,NULL,NULL,'Alex Nuijten','allAPEX',NULL,'Oracle 12c for Developers',REPLACE('Do you want to get up to speed with the most current release of the Oracle database? Then this session is for you. You will learn the most exciting and most useful new features from the Oracle Database 12c which can make your work as database developer a lot easier. There is more to the Oracle database 12c than just pluggable databases.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Data Warehousing & Big Data','Data Architecture',NULL,NULL,NULL,'Kerry Osborne','Accenture',NULL,'The Hybrid World   RDBMS + Hadoop',REPLACE('The hybrid world is coming! There is no doubt that hadoop has established a foothold in traditional enterprises by now. On the other hand, the well-established RDBMS products are far from dead. One of the major problems with hadoop is that the native open source SQL engines are just not as capable as the traditional RDBMS engines. That s understandable since the traditional RDBMS guys have a 20+ year head start. Oracle for example is the king of the hill with regards to complex transactional systems and has the most powerful SQL engine on the planet. What that means is that moving an application to hadoop generally requires a major effort to re-write the data access layer (i.e. the SQL). Nevertheless, the power and the scalability of the distributed hadoop architecture are undeniable. So why not use the best of both worlds? The combination of the two can create a platform that combines the best of both architectures. This presentation will discuss approaches for building just such a hybrid platform. This presentation includes a case study showing a hybrid architecture combining Oracle and hadoop in an innovative use case that shows ankle bracelet tracking data with a google map interface.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Real World',NULL,NULL,NULL,'Bartosz Ostrowski','Pretius',NULL,'APEX plugins that I use in every project',REPLACE('Thanks to APEX architecture we - the developers - can create advanced and reusable components called plugins. Ingenuity and creativity of developers results in many free and handy plugins, that save time, enhance application and show that APEX is not only collection of basic charts and reports.<<CHR(10)>><<CHR(10)>>During this presentation I will talk about APEX plugins that I use in big commercial projects. I will show how you can extend your application and add today features that are listed in APEX roadmap for tomorrow.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Dev',NULL,NULL,NULL,'Mauro Pagano','Accenture Enkitec Group',NULL,'Adapting to Adaptive Plans on 12c',REPLACE('Did you notice that many navigation apps can suggest you in real time to deviate from the initial route because of traffic or accidents?<<CHR(10)>>It''s pretty cool right? You wanted to take 5th but there is an accident so your initial plan doesn''t look so good anymore once you hit the road.<<CHR(10)>>Oracle 12c can do the same, the optimizer can generate an execution plan (your route) keeping the door open for changes in case more data than expected is being processed (traffic / accident).<<CHR(10)>>This is a great feature but it requires a little shift in the way we think about performance, we need to be more open to changes just like our nagivation app. <<CHR(10)>>This session focuses on how this feature works, what it means for us, when it can help us and most important how to look at execution plans that can change after they started their execution.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Dev',NULL,NULL,NULL,'Mauro Pagano','Accenture Enkitec Group',NULL,'Full Table Scan: Friend or Foe?',REPLACE('Full table scan is bad evil", how many times have you heard this claim? It''s one of those myth in the Oracle performance world that never goes away. <<CHR(10)>>It''s only a myth, it''s just plain wrong! Especially nowadays with all the advancements in the software, and not just Oracle.<<CHR(10)>>How many times did you spend time hours trying to avoid a full scan, just to find out performance wasn''t that great once you get an index used?<<CHR(10)>>This session focuses on why full scan has been demonized in the past, why this claim is false, why Oracle is smart enough to chose a full table scan when it''s worth and how to make sure that once Oracle choses it, the full scans runs at its best.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DBA',NULL,NULL,NULL,'Simon Pane','Pythian',NULL,'Modernizing your DBA scripts with the Oracle Scheduler',REPLACE('As the Oracle Database evolves, so should the way DBAs monitor and manage it.  And even though the Oracle Database Scheduler was introduced with Oracle 10g over a dozen years ago, almost all DBA environments still rely heavily on the Linux (UNIX) CRON for scheduling of database monitoring, management, or backup jobs.<<CHR(10)>><<CHR(10)>>But the Oracle Database Scheduler isn''t just for developers and application logic.  Instead it should also be the primary scheduling tool for DBAs and DBA scripts.  Regardless of whether those scripts are SQL based, Linux shell scripts, or Windows command (batch) files.<<CHR(10)>><<CHR(10)>>This presentation convinces DBAs why the Oracle Database Scheduler should be their tool of choice by covering the profound functional and security benefits of using the Oracle Database Scheduler over OS scheduling tools.  How to use and manage the Oracle Scheduler effectively including concrete examples on how to use it with Linux (UNIX) shell scripts and Windows command files is detailed.  Finally exciting new 12c Scheduler enhancements are discussed and demonstrated.<<CHR(10)>><<CHR(10)>>So whether it''s for monitoring jobs, management/maintenance jobs, or even a database backup jobs (RMAN or otherwise), It really is "time to schedule with the scheduler" and get rid of all of those old-school CRONs.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DevOps/Agile',NULL,NULL,NULL,'Simon Pane','Pythian',NULL,'Oracle Database Automation: From Snowflake Instances to DBaaS',REPLACE('Ever wonder why you can spin-up an Oracle Database environment from a public cloud provider in mere minutes yet it takes days to provision and configure one internally?<<CHR(10)>><<CHR(10)>>Oracle database provisioning and management using DevOps style processes may seem like mixing oil & water but it doesn''t have to be that way.  In fact it''s very possible without any additional at-cost tools.  The resulting automation leads to "efficiency", "standardization", and "consistency" - pillars of scalability for effectively managing large database environments.<<CHR(10)>><<CHR(10)>>This presentation reviews how organizations can implement database deployment and management automation as an underpinning technology for a DBaaS using common DevOps tools such as Ansible to: prepare servers, deploy Oracle software, create databases, implement DR configurations, and customize databases with site specific requirements in a highly automated manner.  Regardless of whether the host servers are physically on premise or in the public cloud.<<CHR(10)>><<CHR(10)>>The results are databases that are easier to manage as well as a greatly reduced service time for database provisioning requests.  Literally taking the implementation time down from days to less than one hour end-to-end!','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Detail Plunge',NULL,NULL,NULL,'Tom Petrus','iAdvise',NULL,'jQuery Widgets in APEX',REPLACE('In our everyday APEX life we''re using all these items and regions, which have a lot of settings. What you may not have realised yet however, is that many of the implementations are done through jQuery widgets. Sometimes direct, sometimes inderect through a namespaced wrapper. At times, it''s very interesting to know what''s actually under the hood and how and why things happen. Maybe there are some things that can even be influenced, or altered.<<CHR(10)>>In this session, we''ll be taking a look at some of the widgets which APEX implements, or in some cases have been created by the APEX team. We''ll see how they function and how they can be manipulated or expanded upon.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Real World',NULL,NULL,NULL,'Adrian Png','Insum',NULL,'Building in Blocks',REPLACE('Communications is an integral tool for building communities. The team behind apex.world wanted an effective communication platform for members to interact, and were confronted with the decision to build or integrate. Find out how popular products like MailChimp and Slack were integrated with the apex.world portal. Learn about the challenges faced by the team and how they were solved with some help from the same community that the portal was built for. Take home tips and tricks that you can use in your projects!','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Real World',NULL,NULL,NULL,'Adrian Png','Insum',NULL,'Capturing and Manipulating Images with APEX and More!',REPLACE('A picture is worth a thousand words. It is common to receive project requirements that include image capture, manipulation or both. We can opt to manipulate captured images either on the client-side using JavaScript, or server-side using Oracle Multimedia. This session will examine the various methods and approaches for implementing an image manipulation solution with APEX. We will also look at computer vision and how to integrate this cutting-edge technology in your applications to make users say, "WOW!','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DBA',NULL,NULL,NULL,'Kellyn Pot''Vin-Gorman','Delphix',NULL,'Virtualization-  To Infinity and Beyond!',REPLACE('Cloud is everywhere and the database administrator is caught in the middle.  How do you know where to start and what to migrate first?  How do you perform consolidation planning and ensure data security?<<CHR(10)>><<CHR(10)>>This session builds on the impressive customer experience from Kellyn Pot Vin-Gorman with years of architecting virtualized environments to show how to simply and securely migrate to the cloud.  A full demonstration, along with tips and tricks to show how the DBA can secure their environment to allow a self-service option so they no longer are the road-block to projects!  <<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Optimization',NULL,NULL,NULL,'Daniel Pressman','nTuple',NULL,'Apples to Apples Query and Calc/Aggregation Performance Measurement and Optimization',REPLACE('Learn how to make a true apples-to-apples test of your design decisions by learning about the interactions of Essbase and Operating system caches, in both BSO and ASO.  Learn how to use RAMMAP to understand the IO behind your queries.  Follow a detailed optimization of an ASO cube using these techniques, and see in detail how a number of successful -- and unsuccessful --design changes affect query performance.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Data Integration','Metadata management/integration',NULL,NULL,NULL,'Julia Radovani','Peloton','David Harter, Peloton Group','How to Best Manage Your Relationships &With Data: Building a Strong Foundation for PAREXEL Using Oracle Data Relationship Management Best Practices',REPLACE('With the wide-spread popularity of integrated enterprise systems, a need has emerged for data management technology that drives the timely synchronization and alignment of metadata and transactional data. Leading organizations are positioning purpose-built Oracle data management and integration technologies as strategic pillars for achieving analytical and reporting systems expansion.<<CHR(10)>>This presentation will discuss how PAREXEL, a leading clinical research organization, leveraged Oracle Data Relationship Management (DRM) to achieve data alignment and automation efficiency across changing operational ERP and EPM systems. At PAREXEL, DRM was used to consolidate hierarchies, automate the alignment of common metadata structures in target EPM systems and promote shared data stewardship across Finance and IT functions. Particularly for non-financial master data, DRM enabled critical Project-Client data remediation processes and Organizational modeling capabilities. <<CHR(10)>>In this presentation we will share some industry best practices around data management when integrating Oracle DRM with Financial Data Quality Management, Hyperion Planning, Hyperion Financial Management and Account Reconciliation Manager. Some of the topics include:<<CHR(10)>>&bull;  Mastering financial and non-financial data sets in DRM (Chart of Accounts, Capital Assets, Project, Client).<<CHR(10)>>&bull;  Consolidating maintenance of data mapping rules in DRM to guarantee referential integrity and alignment across ERP and EPM data sets.<<CHR(10)>>&bull;  Rationalizing data specification errors and re-mediating data quality issues from external applications in DRM.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','Other BI and Reporting',NULL,NULL,NULL,'David Rae','Iconomics Inc.','Jenever Springer, Iconomics Inc.','Four Seasons Hotels & Resorts   Solving the Dynamic Content and Calculation Quandary',REPLACE('The complexity of Four Seasons  revenue calculation and reporting process had outgrown their homegrown Excel based solution and was becoming increasingly cumbersome, unable to quickly react to change while also ensuring they delivered timely and accurate and reporting to their management. <<CHR(10)>><<CHR(10)>>Learn how Four Seasons leveraged Essbase and Dodeca''s sophisticated development capabilities to simplify and streamline the on-going evolution of their revenue calculation and reporting workflow, while providing each hotel the ability to customize the content and calculations required to address their specific needs. <<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Detail Plunge',NULL,NULL,NULL,'Peter Raganitsch','FOEX GmbH',NULL,'Finally understand how APEX works',REPLACE('I know, I know, you already used APEX and also built some fine applications. But do you really understand how APEX works and why it behaves as it does?<<CHR(10)>><<CHR(10)>>Have you ever just tried different things until finally something seemed to work? Without actually understanding the what and the why?<<CHR(10)>><<CHR(10)>>Let me try to explain the basics of APEX, the foundation on that all fancy components (IR, Grid, Charts, ...) build up on.<<CHR(10)>><<CHR(10)>>After this session you should be able to understand all the important things: session state, communication, bad and good AJAX calls, and much more.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Integration',NULL,NULL,NULL,'Peter Raganitsch','FOEX GmbH',NULL,'Let APEX access your computer',REPLACE('Web applications are awesome, easy to access from anywhere but also limited in what they can do. All of that happens for security reasons, of course, and that makes us accept that browser apps (like APEX) can''t access any client resources like the filesystem, a printer, or a scanner.<<CHR(10)>><<CHR(10)>>Using the open source Electron project we can build a custom browser, to work around those limitations and extend our APEX applications to do what they need to do.<<CHR(10)>><<CHR(10)>>In this session we will look at what Electron is, how to set it up and what possibilities there are.<<CHR(10)>><<CHR(10)>>There will also some easy-to-use prebuilt examples for you to use after the session.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Data Warehousing & Big Data','Data Integration',NULL,NULL,NULL,'Michael Rainey','Gluent Inc',NULL,'Streaming #Election2016 with Oracle Data Integration',REPLACE('Let s take a look back at one of the more  interesting" election years in the history of the United States using data produced on that day. And not just any data, Twitter data using the #Election2016 hashtag. With so many different opinions being shared on social media, analysis of this data could provide insight into who might win the public vote. Working with open source technologies such as Logstash, Apache Kafka, and Spark Streaming, we can perform in-flight transformations to prepare the Twitter data for analysis. But what about relational data? Quite often we forget that products incubated in the Apache Foundation can also serve a purpose for  standard  relational databases as well. Introducing Oracle GoldenGate and Oracle Data Integrator for Big Data. GoldenGate can extract relational data in real time and produce Kafka messages, ensuring relational data is a part of the enterprise data bus. These messages can then be ingested via ODI through a Spark Streaming process, integrated with additional data sources, such as other relational tables, flat files, etc, as needed, and finally published to one or more targets. Working through the setup, configuration and execution of the #Election2016 social media data experiment, this session will ensure attendees will walk away with a framework on which they can build their data streaming projects, combining relational data with big data and using a common, structured approach via the Oracle Data Integration product stack. And hopefully they take away some  interesting" insight into Election Day 2016 on social media.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Design',NULL,NULL,NULL,'Kumar Ramaiyer','Oracle',NULL,'Essbase Cloud Service -- Architectural Evolution',REPLACE('Essbase Cloud Service: How did it come about? What are its architectural foundations? Why does that matter?<<CHR(10)>><<CHR(10)>>To think that EssCS is an evolution of the Essbase we''ve known and loved since 1992 is to vastly underestimate its power and importance. Moving to the cloud was an opportunity to completely remake Essbase from the ground up -- design, functionality, management, and hardware have all changed and for the better.  Understanding the conceptual, architectural, and technical forces that drove this fundamental shift will enable you to extract the true value of this transformation in your current and new applications. <<CHR(10)>><<CHR(10)>>Join Kumar Ramaiyer, Vice President of Development at Oracle, as he explains how the confluence of development innovations and Essbase resulted in a database unlike any you''ve seen before.<<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Planning','Other Planning',NULL,NULL,NULL,'Greg Ramirez','Pepperdine University','Chase Ross, Pepperdine University','How to win friends and influence people & with an integrated Planning-based forecast process',REPLACE('In this session, you will learn how Pepperdine University transformed an outdated forecast process into one that is forward-looking and engages all areas of the organization by leveraging Hyperion Planning. From a functional standpoint, we will explore the integration of data forms, business rules, and calculation scripts, and how results are delivered to organizational leadership through financial reports.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','Financial Reporting',NULL,NULL,NULL,'Michael Reed','Textron',NULL,'Fun with Financial Reporting',REPLACE('Summary to come','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','Other Database',NULL,NULL,NULL,'Kris Rice','Oracle Corporation',NULL,'Deploying REST services at scale',REPLACE('REST powers the Oracle Cloud.  From how customers build and deploy REST services, to out the cloud itself is built.  This session will cover how Oracle REST Data Services is deployed in the Oracle Public Cloud at scale.  This includes auto configuration for adding capacity on demand, security, tiered architecture, and lots more.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Dev',NULL,NULL,NULL,'Kris Rice','Oracle Corporation',NULL,'REST Enabling the Oracle Database',REPLACE('This session will demonstrate how quickly one can install and configure Oracle REST Data Services (ORDS) to provide/serve REST endpoints on both RESTFul Services and Database Objects themselves.<<CHR(10)>> <<CHR(10)>>A brief overview of REST concepts will be followed by a demo of ORDS being installed in less than 5 minutes.<<CHR(10)>> <<CHR(10)>>Then a series of demos showing how easy it is to REST enable a table and use GET/POST/DELETE to provide a full CRUD API to your data, including complex scenarios involving complex data types like SDO_GEOMETRY and rich web applications that can take advantage of JSON.<<CHR(10)>> <<CHR(10)>>REST is the new development paradigm and the Oracle Database is 100% ready with the addition of ORDS.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Integration',NULL,NULL,NULL,'Jorge Rimblas','Insum Solutions',NULL,'Deliver a Knockout with your APEX Applications',REPLACE('KnockoutJS provides two-way data binding between JavaScript and DOM elements and it''s also the foundation for OracleJET. Whether you use OracleJET or not, KnockoutJS can deliver more pizzazz to your APEX pages. If you often feel your Dynamic Actions are getting too complex, or they are one line of code away from disaster, this session is for you. Come and get a short KnockoutJS tutorial and learn how to integrate it with APEX.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Integration',NULL,NULL,NULL,'Jorge Rimblas','Insum Solutions',NULL,'JavaScript and CSS for PL/SQL Developers',REPLACE('If you have been working with the Oracle Database for a while, but still feel lost when working with JavaScript and CSS in your APEX applications, then this session is for you.  Working with HTML, JavaScript, and CSS doesn''t have to be hard. Learn about CSS selectors, what is the DOM and working with it, JavaScript functions, and even some jQuery. This session will provide you some tools to work better with web technologies.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Planning','Cloud Technologies - PBCS & EPBCS focused',NULL,NULL,NULL,'Mark Rinaldi','Oracle Corporation',NULL,'EPBCS Workforce and Strategic Workforce Planning In Action',REPLACE('Learn how customers are leveraging EPBCS Workforce Planning and Strategic Workforce Planning to complete their Headcount planning based on Supply and Demand Planning.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Data Visualization & Advanced Analytics','Other',NULL,NULL,NULL,'Mark Rittman','Rittman',NULL,'Understanding how a Tweet goes Viral using Oracle Big Data Spatial and Graph',REPLACE('A series of tweets I posted about my 11hr struggle to make a cup of tea with my WiFi kettle ended-up going viral, got picked-up by the national and then international press, and led to thousands of retweets, comments and references in the media. In this session I''ll use Oracle Big Data Graph and Spatial to understand what caused the breakout and the tweet going viral, who were the key influencers and how the tweet spread over various countries in a matter of hours.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Data Warehousing & Big Data','Data Integration',NULL,NULL,NULL,'Mark Rittman','Rittman',NULL,'Making Smart Devices Even Smarter (including iKettles) with Oracle Cloud and Oracle Big Data Discovery',REPLACE('My story about taking 11 hours to make a cup of tea with a WiFi kettle was a fun story that went viral around the world, but it was really a story about data, analytics and the value in bringing these internet-connected devices together. In this session we''ll look at how IoT devices can be connected together, their data streams combined and analyses in real-time, and insights gained via Oracle Big Data Discovery used to make these devices even smarter.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Detail Plunge',NULL,NULL,NULL,'Christian Rokitta','rokit - themes4apex - APEX SmartPivot',NULL,'Browser Developer Tool Essentials for APEX Developers',REPLACE('If you are an APEX developer, you do use a browser to create applications that do run in a browser. Thus the browser is one of your primary tools. When you are developing in SQL or PL/SQL, your IDE (SQL Developer, TOAD, PLSQL Developer,  &) offer you lots of functionality to support your work and enhance productivity. But building web applications, development is not limited to database objects. Suddenly you need to work with HTML, CSS and JavaScript. Although APEX is doing a great job in hiding this complexity with a declarative approach, the more you develop with APEX, the more you will get into these techniques. Suddenly you will need your browser beyond it s rendering capabilities, and indeed, modern browsers are more like an IDE nowadays. <<CHR(10)>>Debugging, testing, performance tuning,  & these are just a few aspects that you can do with your browser. This presentation will go through the latest techniques and features that browsers have to offer for us (APEX) developers, things you should know and use.<<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Other Application Express',NULL,NULL,NULL,'Christian Rokitta','rokit - themes4apex - APEX SmartPivot',NULL,'Hitchhiker s guide to the Universal Theme',REPLACE('When APEX 5.0 was released, it came with an entirely new theme: The Universal Theme. This theme impressively showcased several new features that where build into this new Application Express release: Themestyles, Template Options, Themeroller. These features, and how these are leveraged by the Universal Theme, made building a modern UI much easier and enhanced the User Experience of APEX applications. All an APEX developer must know is, how to use these declarative features. So, let s have a look at these in detail and the state of Universal Theme in APEX 5.1.<<CHR(10)>><<CHR(10)>>But with declarativity comes limitation, and for someone familiar with CSS, Themeroller is  Mostly Harmless . Using the Universal Theme as a standard, the  Answer to Life, Universe and Everything  & : 42, eventually all APEX applications will somewhat look similar. So, what about customizing Universal Theme to really fit your design needs? Well, it s not that easy, but possible. I ll show(case) some options.<<CHR(10)>><<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Optimization',NULL,NULL,NULL,'Edward Roske','interRel Consulting',NULL,'Essbase Optimization from the Experts Panel Session',REPLACE('BSO, ASO, hybrid, Essbase Cloud, Exalytics, virtual machines... with all these Essbase technologies, is there a standard for optimization anymore? In this panel, some of the top Essbase experts of today, tomorrow, and yesteryear will gather to share their wisdom and debate whose wisdom is more correct. Fireworks will definitely ensue as competing optimization tips fly around the room. Relationships may be strained, feelings may be hurt, and brains may be impacted, but rest assured that you will come away having learned that in the world of Essbase, while there is no right answer, there sure are a whole lot of wrong ones.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','OBIEE',NULL,NULL,NULL,'Doug Ross','Performance Architects',NULL,'It''s All About The Data: Oracle BI Cloud Service (BICS) Data Sync and Remote Data Connector',REPLACE('As more companies move their BI environments to the cloud, loading and accessing enterprise data will become as important as front-end visualizations.  Oracle''s BI Cloud Service (BICS) offers two options for those data requirements that go beyond simple data uploads: Data Sync and Remote Data Connector.   This session will demonstrate how to use each tool and offer tips on improving data load and data query performance.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DevOps/Agile',NULL,NULL,NULL,'Bjoern Rost','Pythian',NULL,'DevOpsify DBA tasks',REPLACE('Organizations are struggling to manage and standardize an ever increasing number of<<CHR(10)>>database deployments. This presentation shows how scripting and automation tools can<<CHR(10)>>be used to provision databases and to manage resources like users, tablespaces,<<CHR(10)>>instance parameters and settings in general.<<CHR(10)>>With this setup one can manage a large range of systems from a very small set of<<CHR(10)>>descriptive text based configuration files. More so, these configs are easily managed in a<<CHR(10)>>revision control system like git enabling agile workflows for database change<<CHR(10)>>management.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Tools',NULL,NULL,NULL,'Bjoern Rost','Pythian',NULL,'Oracle & Apache Kafka - Stories from the message bus stop',REPLACE('Apache Kafka is a massively scalable message queue that is being used at more and more places connecting more and more data sources. This presentation will introduce Kafka from the perspective of a mere mortal oracle DBA and share the experience of (and challenges with) getting events from the database to Kafka and possibly even back using different solutions and connectors.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Real World',NULL,NULL,NULL,'Christoph Ruepprich','Accenture Enkitec Group',NULL,'Natural Language Voice Interface to the Oracle Database',REPLACE('Natural language voice interfaces have become quite popular, especially with mobile devices. Apple''s Siri and Google''s "OK Google" have come quite a long way, and are very good at interpreting the human language. A relatively new player on the marked is Amazon''s Echo, a standalone speaker that accepts voice commands and questions, searches for answers on line, and answers back in a human voice.<<CHR(10)>>The technology behind the Echo is Amazon''s Alexa API. This API is available for developers to create their own natural voice interfaces.<<CHR(10)>>We are going to explore how we can use the Alexa API to access an Oracle database to perform spoken inquiries like "How much does Miller earn?", "Who works in the research department?", or "Who earned the highest commission in sales?"<<CHR(10)>>The results will not only be spoken back to the user, but can also be displayed in the Alexa mobile app as well as in APEX.<<CHR(10)>>There will be a live demo of asking questions to an Amazon Echo device, and have it answer with data queried from the database.<<CHR(10)>>A basic understanding of JavaScript and PL/SQL will be beneficial to the participants.<<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Financial Close','HFM',NULL,NULL,NULL,'Beatrice Sagroun','Grant Thornton LLP',NULL,'Leverage HFM APIs to automate part of your HFM end of month process without scripting',REPLACE('What options exist to automate HFM processes? Some would say, "Well, just use HFM Taskflows" but there are some tasks you cannot do in it. So what happen when you need to automate something not available? Happily, Oracle provides an alternate tool to enable more flexible automation with less restriction on which tasks you can automate. This tool is called JHAT (Java HypCon API Tester), previously HAT. It is already located on the HFM server and uses HFM APIs. As an example, if you need consolidations to run in a specific order then need to extract data to an Essbase cube, this can be done using JHAT. During this session, we will discuss JHAT, how it works, where you can find it, examples of automations, and how you can use it with other EPM tools.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Planning','Cloud Technologies - PBCS & EPBCS focused',NULL,NULL,NULL,'Amit Sahasrabudhe','ADI Strategies','Sumit Deo, Huron Consulting Group','End to end automation for Oracle PBCS using EPM Automate',REPLACE('This one hour session on PBCS automation aims to cover all automation aspects that one would encounter in a PBCS implementation. We will discuss the different options available within PBCS to automate tasks such as data loading, running calculations and archiving application artifacts. We will start the session with a brief overview of the EPM Automate utility that will be used to perform a majority of the automation tasks. Next, we will shift focus to Data Management (FDMEE) and learn how the EPM Automate utility can be used to automate tasks for Data Management like uploading a file to Inbox/Outbox folder of Data Management and running a rule to load data from Data Management to PBCS application. In the second half, we will discuss the automation aspects of the PBCS application to cover native data load processes being used and see how metadata can be updated and refreshed. We will also cover automating map reporting application processes. In the end, we will walk through automating the back-up process so that your PBCS application can be backed up daily to an archive folder. This one hour session will cover end to end automation including logging into PBCS, uploading files, running rules, uploading data and metadata files, refreshing metadata and finally automating backups. We will share some code examples with you so it can serve as a quick start for your PBCS automation.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Dev',NULL,NULL,NULL,'Chris Saxon','Oracle Corporation',NULL,'12 Things Developers Will Love About Oracle Database 12c Release 2',REPLACE('Oracle Database 12c Release 2 is here!<<CHR(10)>><<CHR(10)>>The headline features are Sharding, Multitenant and Application Containers. But it''s the improvements to SQL that make a real difference in your day-to-day life work with Oracle Database. <<CHR(10)>><<CHR(10)>>In this session Chris gives you an overview of the changes to SQL and PL/SQL that will help you build faster, more robust database applications. <<CHR(10)>><<CHR(10)>>If you''re a developer or DBA who regularly writes SQL or PL/SQL and wants to keep up to date this session is for you!','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Dev',NULL,NULL,NULL,'Chris Saxon','Oracle Corporation',NULL,'SQL Magic!',REPLACE('In this fun session you ll see SQL used in new and exciting ways. Chris will perform SQL "magic tricks" including:<<CHR(10)>><<CHR(10)>>- Sawing the Query in Half: starting with a normal query, Chris will split it into smaller and smaller chunks  that somehow all give the same result!<<CHR(10)>>- Find the Card: After getting an audience member to choose a "card" (row) from a "deck" (table), Chris will find it by making it float to the top of the table.<<CHR(10)>>- The Magically Changing Data Type: watch as a number changes to a date and back again!<<CHR(10)>><<CHR(10)>>But unlike real magicians, he''ll show you how the tricks work. This will enable you to perform your own "SQL magic  and build better Oracle database applications.<<CHR(10)>><<CHR(10)>>This session is for developers and DBAs looking to expand their SQL skills. It highlights features that are new to 12c as well as little used existing options.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Data Integration','Data management/integration',NULL,NULL,NULL,'Anthony Scalese','Edgewater Ranzal','Francisco Amores','Ask the Experts - An Informal Panel for FDMEE Integrations',REPLACE('Tired of trying to get your FDMEE questions answered in other panels that span all the EPM technologies?  Perhaps you are considering an upgrade to FDMEE, maybe you have already upgraded and are missing key functionality, maybe you are trying to understand your options for cloud integration with FDMEE or maybe you just want to learn more about what you can do with FDMEE.  <<CHR(10)>><<CHR(10)>>In this session, two of the industry''s foremost experts in data integration - Tony Scalese & Francisco Amores Torres - will host an interactive panel with the audience.  Tony & Francisco will share their knowledge drawing on their vast experience implementing and upgrading FDMEE.  This session is vital to anyone that wants to learn more about FDMEE.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Data Integration','Data management/integration',NULL,NULL,NULL,'Anthony Scalese','Edgewater Ranzal',NULL,'FDMEE Scripting - Cloud and On-Premises - It''s Ain''t Groovy, But It''s My Bread And Butter',REPLACE('So you''ve made the transition to FDMEE and now you want more.  FDMEE scripting is what empowers you to do more with the application.  In this session, we will explore how to use FDMEE scripting to enhance and streamline your integrations.  We''ll explore how to use Jython and the various APIs within the EPM stack to take your application to the next level.  Have a hybrid FDMEE cloud deployment?  That''s cool, let''s look at Groovy and EPMAutomate and see how FDMEE can function as your automation hub.  <<CHR(10)>><<CHR(10)>>This session will be most useful for those with a solid FDMEE foundation and some familiarity with scripting languages.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Detail Plunge',NULL,NULL,NULL,'Alicia Scanlan','YCC',NULL,'#LetsWreckThisTogether APEX Talks',REPLACE('Just in case you have not received enough inspiring content by the end of the week, the #LetsWreckThisTogether APEX Talks is back. At last year''s Kscope, this exciting new format was a success.<<CHR(10)>><<CHR(10)>>Instead of long, in-depth "deep dives" on a single topic.  The APEX track of the conference will close with Lightning Talks presented by some of the best and well-known speakers and personalities in the APEX world. <<CHR(10)>><<CHR(10)>>The exact lineup will be announced closer to the event.<<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','None',NULL,NULL,NULL,'Fagner Scheibel','Dell','Rodrigo Radtke de Souza, Dell','OBIEE Going Global! Getting Ready for More Than +140k Users',REPLACE('A standard Oracle Business Intelligence (OBIEE) reporting application can hold more or less 1200 users. This may be a reasonable number of users for the majority of the companies out there, but what happens when an IT leader like Dell decides to acquire another IT giant like EMC and all of their combined 140,000-plus users need to have access to an HR OBIEE instance? What does that setup looks like? What kind of architecture do we need to have to support those users in a fast and reliable way?<<CHR(10)>><<CHR(10)>>This session shows the complexity of Dell s OBIEE environment, describing all processes and steps performed to create such environment, meeting the most varied needs from business demands and L2 support, always aiming to improve environment stability. This architecture relies on a range of different technologies to support that huge amount of end users such as LDAP & SSL, Kerberos, SSO, SSL, BigIP, Shared Folders using NAS, Weblogic running into a cluster within #4 application servers.<<CHR(10)>>If the challenge was not hard enough already, all of this setup also needed to consider Dell s legacy OBIEE upgrade from v11.1.1.6.9 to v11.1.1.7.160119, so we will explain what were the pain points, considerations and orchestration needed to do all of this in parallel.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Tools',NULL,NULL,NULL,'David Schleis','Insum Solutions',NULL,'America s Next Top Model-er Feature',REPLACE('Oracle SQL Developer Data Modeler (SDDM) is a remarkably useful tool, but despite all of the books, blogs and presentations some of its most powerful functionality goes unused. Scripting within SDDM allows any you to make modifications to your model, make sure that your models conform to your standards and also create customized reports that can be used for import into other tools such as Jira.<<CHR(10)>><<CHR(10)>>This session is an introduction to the powerful scripting capabilities found in SDDM, and contains numerous examples of scripts and the SQLgr library that will help you capitalize on the wealth of information captured within your models.<<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Calculation',NULL,NULL,NULL,'Chris Schulze','The Hackett Group',NULL,'Tips and Tricks: Debugging a Broken Calc',REPLACE('Have you ever had a perfectly good calc script or calc manager rule fail to write the numbers you expected?  This debugging guide will give you a reliable, reusable approach to resolve that pesky bug.  You will walk out of this session with a simple list of things to try that will identify most of the bugs you ll encounter.  You ll get done faster, and through the process, substantiate unit testing proof to satisfy your customer.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Essbase-related technologies',NULL,NULL,NULL,'Glenn Schwartzberg','interRel Consulting',NULL,'EssCS: The New Old Essbase',REPLACE('Remember when Essbase could be installed from a floppy disk? You could get a cube running up and running and a couple of days. Well, those days are back with the new Essbase Cloud Service (EssCS). Essbase in the cloud takes us back to simpler times where you can build an Essbase database with a simple Excel spreadsheet template. All you need is Excel and Essbase on the Cloud. Join us for the session where we will walk you through Essbase Cloud Service and how to build Essbase applications in the 21st century. Don''t miss this chance to get to know (reacquainted with) the new old Essbase.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Real World',NULL,NULL,NULL,'John Scott','APEX Evangelists',NULL,'High Performance APEX (Or Don''t keep the users waiting)',REPLACE('Whether you need to support 10 users or 1000 users, its important to understand how your application performs. In this session I will cover the entire stack performance and show how you can debug which area of your APEX application is causing the bottleneck.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Integration',NULL,NULL,NULL,'John Scott','APEX Evangelists',NULL,'Oracle APEX - NLP, AI and Bot Integration',REPLACE('Natural Language Processing (NLP), combined with AI and Bots are hot topics right now. In this session we will cover exactly how you can integrate these technologies into your APEX applications to really make your APEX applications user friendly.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','OBIEE',NULL,NULL,NULL,'Christian Screen','Datavail',NULL,'Data, Data Everywhere but not a Metadata Dictionary to Read',REPLACE('Until recently, the use of a data dictionary or metadata dictionary in most organizations has been an understood value-add need but still an unfulfilled desire. If business users could understand where dashboard data was coming from and what the data columns actually mean, then more confidence, governance, and usage in the reporting system could be achieved. The undertaking of compiling a metadata dictionary across a potential slue of candidate data sources can seem daunting or as fluff for IT but the business users know the importance of understanding the meaning of their data and data lineage. How can a better more usable metadata dictionary be created for Oracle BI? How can a data dictionary be controlled or used to its utmost potential?  Why do you need a data dictionary? And, Who will maintain it? This session provides clear innovative answers to these questions and more by taking the audience through creating an ideal metadata dictionary, showing best practices for maintaining it, and how to report accurately from it to support any reference or data governance concepts in your BI program.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Data Warehousing & Big Data','Data Architecture',NULL,NULL,NULL,'Christian Screen','Datavail',NULL,'I know why the on-premise Oracle BI Applications sings: Migrating OBIA to the Cloud',REPLACE('Cloud solutions continue to expand into the mainstream with obvious material value for businesses that have historically focused on their on-premise solutions. With all major concerns for security in the cloud addressed by bank grade encryption, integration by REST APIs and other supported interfaces, and a growing base of supported production customers, the concerns are turning to action. But there are still lingering questions on architectural best practices and the general approach to move from on premise to the cloud especially for multi-tiered solutions such as Oracle BI Applications. Questions are now less about concern and more about how to move forward. How much of the on-premise software architecture can be migrated to the cloud? And, how can it be done with best practices with the least risk and exposure? And, while getting it right the first time?  This session discusses best practice architecture for migrating the Oracle BI Applications to the cloud. It focuses on the Oracle cloud platform and database services, with a nod to infrastructure services, to lay out the idea of the hybrid cloud and variations of the new age cloud BI/DW architecture for your analytics environment to succeed while operating at the same reliability or better all the while benefiting from what the cloud offers best.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Financial Close','Financial Close in the Cloud',NULL,NULL,NULL,'Marc Seewald','Oracle Corporation',NULL,'Introducing the Oracle Tax Reporting Cloud',REPLACE('Corporate taxation continues to receive significant focus from regulators. Because of this there is an increasing need to connect tax reporting with financial and management reporting. The new Oracle Tax Reporting Cloud Service offers a single solution for all tax reporting requirements and keeps you connected with other ERP and EPM reporting processes. The solution automates such processes as the tax provision and Country by Country Reporting (required for the new OECD BEPS - Base Erosion and Profit Shifting initiative). This session will be very relevant for any existing Oracle ERP & EPM customers.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Planning','Cloud Technologies - PBCS & EPBCS focused',NULL,NULL,NULL,'Marc Seewald','Oracle Corporation',NULL,'World-Class Marketing Planning with Oracle Cloud',REPLACE('In this session, learn how combining Oracle Enterprise Planning Cloud for marketing financial planning with your current customer experience (CX) investment can help align your marketing and finance plans. The solution enables you to plan the financial impact of marketing campaigns, ensure that the actual marketing spend is aligned with the budget, and calculate the return on marketing investment. The solution gives marketing leaders confidence in driving their business forward because it integrates with your current CX system to provide a strategic and seamless marketing platform.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','OBIEE',NULL,NULL,NULL,'Teal Sexton','UC Berkeley',NULL,'A two-pronged approach to flexible and scalable BI security.',REPLACE('After years of frustration with the old approach to security across a plethora of subject areas in Oracle Business Intelligence Enterprise Edition, UC Berkeley recently implemented a truly flexible and scalable security model. The two pronged approach includes a data security layer implemented through Oracle Virtual Private Database policies and a small number of application roles to govern what the user sees in the application itself. Our database policies mask rather than eliminate the data in columns a user is not authorized to see.  Attend this exciting presentation to learn and have more fun that you thought possible at a security session!','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DBA',NULL,NULL,NULL,'Craig Shallahamer','OraPub',NULL,'How To Determine The Financial Cost Of Running A SQL Statement In The Cloud',REPLACE('Poor performing SQL statements "cost" an organization in many ways. But assigning an actual dollar amount has been extremely difficult... until the cloud came along. Why? Because cloud customers are charged based on computing resource usage. And, Oracle keeps great statistics on SQL statement usage. So, why not just combine the two?<<CHR(10)>><<CHR(10)>>Imagine what you can now do. You can determine how much money each SQL statement costs per month. What is the costliest SQL statement in your entire application? You can even ask predictive type questions. For example, if I reduce a statement''s buffer gets from 1M to 100K, how much money will the organization save each week or just during the month end close?<<CHR(10)>><<CHR(10)>>All these questions and many more can now be answered with precision. In this presentation I will show you how to answer these types of questions referencing standard AWR data.<<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Tools',NULL,NULL,NULL,'Shay Shmeltzer','Oracle Corporation',NULL,'Developing JavaScript Applications - The Oracle Offering',REPLACE('JavaScript might be the most used development language out there today. In this session we''ll review Oracle''s tools and framework for developing applications with JavaScript. We''ll talk about the complete ecosystem Oracle has built around JavaScript discussing and demoing Oracle JET, Oracle Application Builder Cloud Service, Oracle Developer Cloud Service and more. Learn about the architecture and the relationships between the various products and when they''ll be useful for you.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Dev',NULL,NULL,NULL,'Carlos Sierra','Accenture Enkitec Group',NULL,'SQL Tuning 101',REPLACE('SQL Tuning is a complex and intimidating area of knowledge, and it requires years of frequent practice to master it. Nevertheless, there are some concepts and practices that are fundamental to succeed. From basic understanding of the Cost-based Optimizer (CBO) and the Execution Plans, to more advance topics such as Plan Stability and the caveats of using SQL Profiles and SQL Plan Baselines, this session is full of advice and experience sharing. Learn what works and what doesn''t when it comes to SQL Tuning.<<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Tools',NULL,NULL,NULL,'Carlos Sierra','Accenture Enkitec Group',NULL,'Understanding SQL Trace, TKPROF and Execution Plan for beginners',REPLACE('On this session participants will learn about producing a SQL Trace then a summary TKPROF report. A sample TKPROF is navigated with the audience, where the trivial and the no so trivial is exposed and explained. Execution Plans are also navigated and explained, so participants can later untangle complex Execution Plans and start diagnosing SQL performing badly.<<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Planning','Cloud Technologies - PBCS & EPBCS focused',NULL,NULL,NULL,'Luke Sinnen','SC&H Group',NULL,'Going beyond Finance into Operations with Oracle''s Planning and Budgeting Cloud Service (PBCS) at the largest Oracle EPM Cloud deployment to date for ',REPLACE('At the enterprise level, cloud computing is transforming operational effectiveness, creating strategic value, and helping today s global businesses to gain a true competitive advantage. In this session, you will see how the largest Oracle Planning and Budgeting Cloud Service (PBCS) deployment to date changed how the organization manages it budgeting and forecasting capabilities. Specifically, this presentation will focus on how the PBCS application became a budgeting and forecasting tool that is intuitive, easy to use, scalable and fast on a modern technology (PBCS). Ultimately, this case study showcases how any large global organization can benefit from Oracle EPM Cloud solutions in ways that create long-term operational efficiencies and competitive advantage.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Real World',NULL,NULL,NULL,'Stephen Smith','CampaignShortCuts','Roel Hartman, APEX Consulting','From APEX App to Apple App Store   Simple Steps for Successful Submission',REPLACE('Want to learn how to prepare your APEX app for successful submission to the Apple App Store?  This session will show you how to program the needed requirements and navigate the process steps to publish your app in the App Store.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','OBIEE',NULL,NULL,NULL,'Kristi  Smith','eCapital Advisors',NULL,'To the Cloud and Beyond!!',REPLACE('As the number of companies entering the Cloudsphere continues to grow, the need for a step by step guide on how to begin your Oracle Business Intelligence Cloud Service (BICS) journey becomes increasingly more important. Even if you are contemplating purchasing BICS, this session will give you more details on what you get with BICS and how BICS works. After all, even Buzz Lightyear himself needed a little training before he became a space ranger hero. Before you can begin to capitalize on the benefits of the cloud, there are a series of steps you will need to walk through in order to get started with BICS. This session will outline what you get with your initial purchase, we will discuss the Data Loader and Data Sync Utility, as well as instructions on how to model your data and start building data visualizations. As with most superheroes and BI Consultants alike, time is of the essence, so come and learn how to quickly get up and running with BICS, so you can be on your way to saving the galaxy!','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Tools',NULL,NULL,NULL,'Jeff Smith','Oracle Corporation',NULL,'SQL Developer: Three Features You''re Not Using But Should Be',REPLACE('You write SQL, get results.<<CHR(10)>><<CHR(10)>>You click around objects, get data to Excel.<<CHR(10)>><<CHR(10)>>You write PL/SQL, compile it and view your errors.<<CHR(10)>><<CHR(10)>>That describes what 80% of our users do in Oracle SQL Developer. This session will expose 3 features that will turbo-charge your experience with SQL Developer and the Database. This session aims to make you more productive and valuable to your Oracle Database development organization. <<CHR(10)>><<CHR(10)>>Learn how to take those 600 files you currently have all of your hand crafted SQL in and turn them into interactive reports. <<CHR(10)>><<CHR(10)>>Learn how to find stuff in your database by taking advantage of PL/Scope and our search feature.<<CHR(10)>><<CHR(10)>>Learn how to build your own screens - that''s right, learn how to use a bit of basic XML and SQL to extend SQL Developer to do what you want it to do.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DB Tools',NULL,NULL,NULL,'Jeff Smith','Oracle Corporation',NULL,'SQLcl & SQL Developer Tips & Tricks',REPLACE('Fewer keystrokes, fewer clicks = more code, more productivity, more fun.<<CHR(10)>><<CHR(10)>>This session concentrates on the power features that most users bypass when using Oracle SQL Developer and our new command line interface, SQLcl. Do you use all of the shortcuts available to you? After this talk, you''ll know how to get what you want, as quickly as you want.<<CHR(10)>><<CHR(10)>>We''re rebuilding this session from scratch. That''s right, in 2017, this talk will be BRAND NEW. So if it''s been awhile since you''ve seen it, come back and get caught up.<<CHR(10)>><<CHR(10)>>As always, our goal is for each attendee to pick up one to three techniques that will drastically impact their productivity and save them time when working with Oracle Database.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Business Content','Other EPM Business Content',NULL,NULL,NULL,'Michael Smith','TopDown Consulting','Steven Densford, Starbucks','Agile/Scrum, a new way to manage your project development and delivery',REPLACE('Scrum, one form of Agile software development, has been used successfully at Starbucks on many projects.  Scrum and Agile Software Development are topics that continue to be discussed but very few people can actually put their real world experiences on display like we can. This session will look at the process from the initial design discussions through the development of the product backlog and on into the bi-weekly sprints for development.  The key roles will be discussed which include the Scrum Master, Product Owner, and team members (developers).  Some tools will be discussed as well. Our team has found ways to adapt our past experiences successfully into Scrum and make it successful.  It''s not all roses, we will also share our challenges with Scrum and how we have overcome them.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Other Essbase',NULL,NULL,NULL,'Veronica Snow','Your Conference Connection',NULL,'Essbase Placeholder',REPLACE('Essbase Placeholder for Oracle','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Financial Close','HFM',NULL,NULL,NULL,'Matt Spencer','Finit Solutions',NULL,'Cash Flow 2D vs. 3D   How to Make Your Data Stand Out',REPLACE('Come explore various approaches to everyone s favorite financial   the Cash Flow Statement. Learn the difference between the two-dimensional (using 2 HFM dimensions) and three-dimensional (using 3 HFM dimensions for additional detail) approaches, different ways to tackle each, and which one may be a better fit for your business. A brief overview of the Statement of Cash Flows will be provided   no CPA certification required!','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Real World',NULL,NULL,NULL,'Scott Spendolini','Sumner Technologies',NULL,'GET POST ORDS JSON: Web Services for APEX Decoded',REPLACE('Web Services in the APEX world are becoming more and more popular.  However, there is still a lot of confusion as to what they are and how they could benefit the APEX developer.  After a review of the syntax and jargon associated with web services, this session will review and boil down web services to their basic components.  It will then demonstrate how APEX developers can start to use these powerful components - both to send and receive data from other sites.  <<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Real World',NULL,NULL,NULL,'Scott Spendolini','Sumner Technologies',NULL,'Secure Your APEX Applications with APEX-SERT',REPLACE('Application security is at the forefront of IT and will remain there for a long time.  Thus, it important to consider security on day one of your application s development.  APEX-SERT is an open-source tool built in APEX that is designed to help evaluate your APEX applications for potential security issues.  Not only will it identify them, but it will also offer advice on how to remedy them.  APEX-SERT also offers the ability to create and approve exceptions in the case of either a false positive or an issue that is mitigated outside of APEX.<<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Real World',NULL,NULL,NULL,'Przemyslaw Staniszewski','Pretius',NULL,'APEX Localization',REPLACE('Terms "translation" and "localization" are often used interchangeably, while the differences are quite significant. If we want to create professional international application we must not only care about language, but also about elements that appeal to regional or cultural preferences including text direction, formats, calendars etc. <<CHR(10)>>During this presentation I will show:<<CHR(10)>>- how localization process works;<<CHR(10)>>- how you can cover it in APEX using built-in features, plugins and open source projects like OraOpenSource and translate-apex.com;<<CHR(10)>>- how you can use good practice from video game industry to create international APEX applications.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Essbase-related technologies',NULL,NULL,NULL,'Ronnie Tafoya','interRel Consulting',NULL,'Migrating to Essbase Cloud: Why, When, & How',REPLACE('Essbase is finally in the cloud! So should you consider migrating to the cloud? Join us for the session where we will introduce and demo Essbase cloud services. We will show you all the features and functions available in EssCS, show you what is the same between on prem and the cloud, and what is different. We will review how the steps to migrate your Essbase applications to the cloud and what roadblocks and pitfalls to look out for. We will then show you how to maintain your Espace applications in the cloud. - dimension builds,data  integrations, automations, and more. Essbase in the cloud is not for everyone just yet   come to the session to learn when and why it would make sense for you.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DBA',NULL,NULL,NULL,'Biju Thomas','OneNeck IT Solutions',NULL,'Do more with Data Pump: Tips and Techniques',REPLACE('Datapump was introduced in Oracle Database 10g, and has evolved over the versions with various features and performance improvements to migrate data and objects. The legacy export (exp) / import (imp) utility is still maintained in all versions of database including 12c for backward compatibility, and to migrate legacy data to newer versions of database. In this session the speaker shows you how to extend datapump for your various data and object migration needs outside of copying a table or schema. You will learn to export public and private database link and synonyms, various object filtering and row filtering techniques, improving performance of data pump operations, migrate data without using any space for dump file, changing storage properties during export and import, and methods to verify the contents of export dump file.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Financial Close','Other Financial Close',NULL,NULL,NULL,'Paulo Jos Thrige','FLSmidth A/S',NULL,'HFM Admin s life made easier with EPM Maestro, WebSymphony, admin switches and some copying!',REPLACE('For several years FLSmidth has been using HFM for the Financial Consolidation and has been using tools and techniques to reduce the workload on recurrent manual procedures. This is done by re-use of scripts with EPMMaestro (third party tool) that include multiple tasks like copying, calculation, consolidation and process management   See how to build a script in a few minutes that does it all! For the users the addition of WebSymphony (web part of EPMMaestro) have given the users some features that HFM cannot do or is cumbersome to do. <<CHR(10)>>In addition we have reduced the need for frequent rules loads (due to business changes) by adding rules logic that are triggered by values in trigger accounts in order to turn on rules like Process Management Locks. The recent EPM upgrade from 11.1.2.1 to 11.1.2.4 also made it necessary to explore the new tools for migrating and copying HFM applications between different environments.<<CHR(10)>><<CHR(10)>>The presentation cover topics like:<<CHR(10)>>&bull;  EPMMaestro<<CHR(10)>>o  What does it do and why should I bother?<<CHR(10)>>o  Adapting to the world of Java<<CHR(10)>>o  Scripting   Let s get under the hood!<<CHR(10)>>o  Examples on recurrent Closing tasks run by EPMMaestro<<CHR(10)>>&bull;  Websymphony<<CHR(10)>>o  Extending the HFM tools with nice features<<CHR(10)>>o  Run elevated tasks by regular users<<CHR(10)>>o  Transparency in your application<<CHR(10)>>&bull;  Admin switches   Turn your rules on and off without having to load rules.<<CHR(10)>>&bull;  Copy, copy, copy<<CHR(10)>>o  Import Application, Duplicate Application and HFMCopyApplication   How do they work and when to use them?<<CHR(10)>>o  Unorthodox application migration by DB Magic<<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','OBIEE',NULL,NULL,NULL,'Francesco Tisiot','Rittman Mead',NULL,'What a Successful OBIEE 12c Upgrade Project Looks Like: Liberty Global - Customer Case Study',REPLACE('OBIEE 12c is the latest generation of Oracle''s Enterprise analytics and reporting tool, bringing with it many powerful new features. Many users are still on earlier releases of OBIEE 11g or even 10g, and are looking to understand how they can move to OBIEE 12c to benefit from its new capabilities. <<CHR(10)>>Liberty Global are a global telecommunications company, with a long history with OBIEE going back to 10g. They wanted to move to OBIEE 12c in order to use the new Advanced Analytics options, and used Rittman Mead to support them with the full scope of the upgrade.<<CHR(10)>>In this presentation we will see what a highly successful OBIEE 12c migration looks like. We will cover clear details of all the steps required, and discuss some of the problems encountered. Regression testing is a crucial step in any upgrade and we will show how we did this efficiently and accurately with the provided Baseline Validation Tool. This presentation will assist all attendees who are considering, or in the process of, an OBIEE 12c upgrade.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Other Essbase',NULL,NULL,NULL,'Tim Tow','Applied OLAP, Inc.',NULL,'Introduction to Java and the Essbase Java API',REPLACE('Many Essbase customers and partners have requirements that extend beyond the ''out-of-the-box'' capabilities shipped with the product.  Thankfully, Essbase is a platform that features a very robust Java API that provides nearly endless possibilities  allowing customers the ability to leverage their Essbase investment.  Attend this session to learn the basics of how to get started with the Java programming language and with the Essbase Java API.<<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('EPM Data Integration','Cloud Integration',NULL,NULL,NULL,'Jake Turrell','Turrell Consulting',NULL,'Introduction to the EPM REST APIs',REPLACE('Oracle''s EPM REST APIs allow developers to automate and integrate their environments using any programming language with an HTTP client library.  This session will provide attendees with a tour of the EPM REST API landscape and will give developers concrete examples they can build upon themselves.  Users will leave this session with an understanding of basic REST concepts and the confidence to develop their own REST API integrations for Planning, Migrations and Data Management.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','ADF and MAF',NULL,NULL,NULL,'Mia Urman','AuraPlayer',NULL,'Digital Transformation: Strategy for Moving from Legacy to Enterprise Mobility',REPLACE('As mobile becomes the primary means for accessing information, enterprises must find a way to accelerate mobilization. The Oracle Mobile Cloud is the missing ingredient to create mobile apps at the speed of your business and empower the front lines of your business with back office data. Oracle Mobile Cloud Service provides built-ins for push notifications, object storage, user management, analytics, and an API designer and catalog. But what should you do if your business is stuck with a mountain of Oracle Forms or EBS? How can you leverage your existing business logic while transforming the user experience to the digital world? In this session we will discuss how to begin your mobile journey; Including real life examples of customers who have been successful at it! This session will also include demos of how Oracle Mobile Cloud Service makes it possible for customers to mobile-enable their legacy systems.<<CHR(10)>><<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('BI & Reporting','Other BI and Reporting',NULL,NULL,NULL,'Jacques Vigeant','Oracle Corporation',NULL,'Oracle Analytics Mobile - Disrupt the Enterprise (In a Good Way)',REPLACE('Summary to come','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Financial Close','HFM',NULL,NULL,NULL,'Henri Vilminko','Infratects',NULL,'Take Control of Your HFM Environment',REPLACE('Which users have been active in HFM during the past year? How many concurrent users are accessing the system during busy periods? Why is the volume of HFM data growing so fast? What Financial Reporting reports are used most frequently? These are the kind of questions that Financial Management administrators often need to answer. In this session I will show you how to get answers to the aforementioned questions - and more - using tools that are available without additional cost.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Planning','Cloud Technologies - PBCS & EPBCS focused',NULL,NULL,NULL,'Shankar Viswanathan','Oracle Corporation','Prasad Kulkarni, Oracle','What s New, What s Next: Oracle Planning and Budgeting Cloud Service',REPLACE('Oracle Planning and Budgeting Cloud Service (PBCS) is one of Oracle s broad selection of enterprise-grade cloud solutions delivered via software as a service. This session provides an overview of this solution and an update on new and planned functionality.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Data Visualization & Advanced Analytics','R and Oracle Data Mining',NULL,NULL,NULL,'Tim Vlamis','Vlamis Software Solutions','Cathye Pendley, Vlamis Software Solutions','Starting with Oracle Data Science in the Cloud',REPLACE('Everyone knows they should be integrating data mining and predictive analytics, but it can be challenging to discuss the merits of a project before team members share a common understanding of data science and predictive analytics. We will share a detailed outline of the best practice methodology for getting clients started with Oracle Data Mining and Oracle R Enterprise, how we develop that common understanding using "live" software, and how to facilitate brainstorming sessions to identify projects with the highest ROIs. We''ll share excerpts from our 3-day start up process to create a common set of skills and knowledge through hands-on learning with live software and complemented by expert guidance for placing tools and algorithms within a broader analytics context. We ll help you stand up instances in in the cloud, do data science projects on your data, show you how to use Oracle Data Mining and Oracle R, and help you pick the right starting point for your organization.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Application Express','Integration',NULL,NULL,NULL,'Jerry Ward','Viscosity North America','Paul Hicks, Kaminario','Visualizing Air Traffic Data with the FAA s Satellite-based Surveillance System, a Pizza Box, a Raspberry PI, Apex, JET, and the Oracle IOT Cloud',REPLACE('In this session we  science the #$%! * out of a Raspberry Pi 3, Apex and the Oracle Internet of Things Cloud (*ref. The Martian Film). The Automatic Dependent Surveillance Broadcast (ADS-B) is a precise satellite-based surveillance system that broadcasts real-time weather and uses GPS technology to determine any aircraft''s location, airspeed, other date, and relays that data to air traffic control, aircraft, and to us because we are listening! We log and store this data in the Oracle IOT Cloud, then use Apex to build a simple application to view this data in real time and report on it over time.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Data Visualization & Advanced Analytics','R and Oracle Data Mining',NULL,NULL,NULL,'Jerry Ward','Viscosity North America','Kevin McNelis, Nutrabolt Life Sciences','Data Stories: Predicting Asset Prices with Oracle Data Visualization Desktop, Data Collection, and R',REPLACE('Data has a story to tell, and if told correctly, data can predict the future. In this session we aim to predict the future value of any asset through storytelling.  We illustrate this with an intriguing tale using a technique that you can apply to the purchase or sale of your next car, boat, home, or airplane. We use a popular business aircraft as an example to tell this story. You will learn how you can quickly and easily: scrape the data from a market website, use Oracle Data Visualization desktop to identify the price drivers of this market, and the final result into a simple R statement that will predicts the future!','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Planning','Cloud Technologies - PBCS & EPBCS focused',NULL,NULL,NULL,'Matt Ward','Peloton',NULL,'Enterprise PBCS Enables Integrated Planning for the Merger of Citrix s GoTo and LogMeIn',REPLACE('For many organizations, financial and business planning is a complex process facilitated by time consuming spreadsheet activities including preparation, data input, performing calculations, producing reports, and executing reviews.  This process is repeated monthly, quarterly, and annually such that the effort consumed by the disparate offline processes, and ultimately the costs of these tasks, are compounded over time.  And for organizations going through a merger these inefficiencies and costs are multiplied further, as planning processes are typically required for the combined entity in addition to the legacy standalone entities.  But it does not have to be that way...<<CHR(10)>>Oracle s Enterprise PBCS solution provides a path for the rapid deployment of integrated planning business processes in the most common functional areas including Financials, Workforce, Capital, and Projects.  Using the configurable features of these out-of-the-box capabilities, organizations are presented with an opportunity to dramatically reduce the effort and cycle time of planning processes, while doing so at lower overall cost. <<CHR(10)>>The session will share the story of the merger of Citrix s GoTo division with LogMeIn.  Enterprise PBCS was implemented in just 10 weeks to facilitate combined planning and reporting for the new organization, leveraging all four business processes within the product suite.  This session will be co-presented with Oracle Product Management.  <<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Essbase-related technologies',NULL,NULL,NULL,'David Wells','Williams','Arijit Chanda, Williams','We Make Energy Happen:  Oracle EPM Client Success Story at Williams',REPLACE('After an enterprise-wide reorganization, the FP&A group was faced with growing business requirements, slow and outdated systems, missed deadlines, and frustrated users.  Learn how Williams super-charged its EPM environment using Planning, Essbase ASO, and Dodeca to cut processing times from 4 hours to 15 minutes and increase data capacity by over 10 times.  With the system bottlenecks removed, the Finance organization is not only meeting deadlines, but performing more-comprehensive analyses and other projects neglected previously due to system restraints.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Essbase-related technologies',NULL,NULL,NULL,'Jordan Wilcox','TopDown Consulting','Rhonda Brigham, Starbucks Coffee Company','Handling Textual Data in Planning and Essbase: A Starbucks Case Study',REPLACE('Handling text data in a Hyperion Planning application is relatively easy and straightforward. Planning metadata is stored in a relational database. This textual information is accessible via web forms, HFR, and Smart View out-of-the-box.  On the other hand, managing and reporting on text data is not quite as simple in the Essbase technology. Essbase handles dates and smart lists but can t handles freeform text values. The situation is further complicated by the fact that your smart lists need to be synchronized between Planning and Essbase for the data transfer to be accurate. In this session, Jordan Wilcox, TopDown Consulting, and Rhonda Brigham, Starbucks, will discuss how they used a creative approach to get text data in three different forms smart lists, dates and freeform text data to flow from Planning to Essbase. They will discuss the overall project goals, technologies, POCs, and the reason for choosing the solution they did, including design and results.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Essbase','Essbase-related technologies',NULL,NULL,NULL,'Stuart Yasukochi','St. Jude Medical, Inc.','Doug Pearce, Analysis Team','Essbase Does it, but Dodeca Makes It Easy! (The Sequel)',REPLACE('St.  Jude Medical identified three key technical hurdles to converting their worldwide planning applications to a single ASO database.  Learn how Currency Translation, Workforce, and Supporting Details  complex functionality was achieved using core Essbase functionality with Dodeca s versatility.  Seamless integration between relational input views and Essbase provided for employee-level workforce planning and generalized supporting details inputs.  Simple operations in BSO are not so simple in ASO such as currency conversion.   Join us to learn how SJM was able to surmount these obstacles with increased efficiency and reduced complexity.','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Planning','Administration',NULL,NULL,NULL,'Tim Young','Walmart',NULL,'How To Succeed in Planning Without Really Trying:  Practical Application of Past KScope Sessions',REPLACE('As we attend sessions and webinars, we pick up some great ideas from our fellow ODTUGers.  But often we end up with as many questions as answers.  We see cool Planning utilities, but the syntax looks like gibberish.  Error trapping is cool, but what good is it? Can I update my Planning outline without blowing up my application?  Can I test my load file without actually touching the repository tables?  What s the point of being able to save an LCM Migration definition?  Member formula development in Planning is cumbersome, can I speed it up?  How can I add 300 users across a dozen domains to a Security group without taking all week?  My on premises cube won t load and recycling services didn t fix it, can I get it moving without bringing down the Windows server? <<CHR(10)>><<CHR(10)>>There has to be an easier way! There is, and we show the way by attacking these questions and more, showing you the path to making the system speak to us instead of screaming at it in the wee hours. <<CHR(10)>>','<<CHR(10)>>',CHR(10)));
INSERT INTO ero_kscope_sessions (topic,subtopic,starttime,endtime,session_id,presenter,company,copresenter,title,description)
VALUES ('Database','DBA',NULL,NULL,NULL,'Kai  Yu','Dell EMC',NULL,'Leveraging Oracle Database In-Memory to Accelerate Business Analytic Applications',REPLACE('By introducing In-Memory column store, Oracle Database In-Memory (DBIM) significantly improves the performance for analytic queries as well as mixed workloads.  Come to this session to learn Oracle Database In Memory under the hood:  the dual format memory architecture and configuration, how the data is populated into In-Memory column store and  it helps query performance. . This presentation also covers further enhancements of DBIM in Oracle Database 12cR2: Join group, and In-Memory expression, In-Memory active Data Guard support, etc.   Through some case studies of business analytics projects, this presentation covers the practices of leveraging DBIM to improve the query performance of business analytic applications and how to use In-Memory adviser to determine the objects that need to be loaded into In memory column storage . We also will present some analysis on the performance gains by using IM memory features and when and how these gains can be achieved.','<<CHR(10)>>',CHR(10)));

COMMIT;

