prompt Silently drop previously created objects that may exist
prompt =======================================================
declare
  --
  -------------------------------------------------------------------------
  --                                                                     --
  --       _/_/_/_/              _/_/_/      _/_/      _/_/_/    _/_/_/  --
  --      _/        _/      _/  _/    _/  _/    _/  _/        _/         --
  --     _/_/_/    _/      _/  _/_/_/    _/    _/  _/          _/_/      --
  --    _/          _/  _/    _/    _/  _/    _/  _/              _/     --
  --   _/_/_/_/      _/      _/    _/    _/_/      _/_/_/  _/_/_/        --
  --                                                                     --
  -------------------------------------------------------------------------
  --
  cn_type_acl      constant  varchar2(30) := 'acl';
  cn_type_type     constant  varchar2(30) := 'type';
  cn_type_package  constant  varchar2(30) := 'package';
  
  procedure silent_drop_object
  (p_type  in  varchar2
  ,p_name  in  varchar2
  )
  is
    e_object_not_exists   exception;
    e_acl_not_exists      exception;
    e_acl_not_found       exception;
    pragma exception_init (e_object_not_exists, -4043);  -- ORA-04043: object does not exist
    pragma exception_init (e_acl_not_exists   ,-31001);  -- ORA-31001: Invalid resource handle or path name
    pragma exception_init (e_acl_not_found    ,-46114);  -- ORA-46114: ACL name  not found.

  begin   -- silent_drop_object
    if p_type = cn_type_acl
    then
      dbms_network_acl_admin.drop_acl (acl => p_name);
    else
      execute immediate 'drop '||p_type||' '||p_name;
    end if;

  exception
    when e_object_not_exists
      or e_acl_not_exists
      or e_acl_not_found
    then
      null;

  end silent_drop_object;

begin
  silent_drop_object (cn_type_acl    ,'kscope_access.xml'     );
  silent_drop_object (cn_type_type   ,'ta_ero_sourcelines'    );
  silent_drop_object (cn_type_type   ,'to_ero_sourcelines'    );
  silent_drop_object (cn_type_type   ,'ta_ero_kscope_sessions');
  silent_drop_object (cn_type_type   ,'to_ero_kscope_sessions');
  silent_drop_object (cn_type_package,'ero$kscope_sessions'   );
end;
/

